/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.hint.HintShadowAlgorithm;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;
import org.apache.shardingsphere.shadow.route.engine.ShadowRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.determiner.ColumnShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.route.engine.determiner.HintShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public abstract class AbstractShadowDMLStatementRouteEngine
implements ShadowRouteEngine {
    private final Map<String, String> tableAliasNameMappings = new LinkedHashMap<String, String>();

    @Override
    public void route(RouteContext routeContext, ShadowRule shadowRule) {
        this.decorateRouteContext(routeContext, shadowRule, this.findShadowDataSourceMappings(shadowRule));
    }

    private Map<String, String> findShadowDataSourceMappings(ShadowRule shadowRule) {
        Collection<String> relatedShadowTables = this.getRelatedShadowTables(this.getAllTables(), shadowRule);
        if (relatedShadowTables.isEmpty() && this.isMatchDefaultShadowAlgorithm(shadowRule)) {
            return shadowRule.getAllShadowDataSourceMappings();
        }
        ShadowOperationType shadowOperationType = this.getShadowOperationType();
        Map<String, String> result = this.findBySQLComments(relatedShadowTables, shadowRule, shadowOperationType);
        if (!result.isEmpty()) {
            return result;
        }
        return this.findByShadowColumn(relatedShadowTables, shadowRule, shadowOperationType);
    }

    private Collection<String> getRelatedShadowTables(Collection<SimpleTableSegment> simpleTableSegments, ShadowRule shadowRule) {
        LinkedHashSet<String> tableNames = new LinkedHashSet<String>();
        for (SimpleTableSegment each : simpleTableSegments) {
            String tableName = each.getTableName().getIdentifier().getValue();
            String alias = each.getAlias().isPresent() ? (String)each.getAlias().get() : tableName;
            tableNames.add(tableName);
            this.tableAliasNameMappings.put(alias, tableName);
        }
        return shadowRule.getRelatedShadowTables(tableNames);
    }

    private boolean isMatchDefaultShadowAlgorithm(ShadowRule shadowRule) {
        ShadowAlgorithm shadowAlgorithm;
        Optional<Collection<String>> sqlComments = this.parseSQLComments();
        if (!sqlComments.isPresent()) {
            return false;
        }
        Optional<ShadowAlgorithm> defaultShadowAlgorithm = shadowRule.getDefaultShadowAlgorithm();
        if (defaultShadowAlgorithm.isPresent() && (shadowAlgorithm = defaultShadowAlgorithm.get()) instanceof HintShadowAlgorithm) {
            ShadowDetermineCondition shadowDetermineCondition = new ShadowDetermineCondition("", ShadowOperationType.HINT_MATCH);
            return HintShadowAlgorithmDeterminer.isShadow((HintShadowAlgorithm)shadowAlgorithm, shadowDetermineCondition.initSQLComments(sqlComments.get()), shadowRule);
        }
        return false;
    }

    private Map<String, String> findBySQLComments(Collection<String> relatedShadowTables, ShadowRule shadowRule, ShadowOperationType shadowOperationType) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String each : relatedShadowTables) {
            if (!this.isContainsShadowInSQLComments(each, shadowRule, new ShadowDetermineCondition(each, shadowOperationType))) continue;
            result.putAll(shadowRule.getRelatedShadowDataSourceMappings(each));
            return result;
        }
        return result;
    }

    private boolean isContainsShadowInSQLComments(String tableName, ShadowRule shadowRule, ShadowDetermineCondition shadowCondition) {
        return this.parseSQLComments().filter(each -> this.isMatchAnyHintShadowAlgorithms(shadowRule.getRelatedHintShadowAlgorithms(tableName), shadowCondition.initSQLComments((Collection<String>)each), shadowRule)).isPresent();
    }

    private boolean isMatchAnyHintShadowAlgorithms(Collection<HintShadowAlgorithm<Comparable<?>>> shadowAlgorithms, ShadowDetermineCondition shadowCondition, ShadowRule shadowRule) {
        for (HintShadowAlgorithm<Comparable<?>> each : shadowAlgorithms) {
            if (!HintShadowAlgorithmDeterminer.isShadow(each, shadowCondition, shadowRule)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> findByShadowColumn(Collection<String> relatedShadowTables, ShadowRule shadowRule, ShadowOperationType shadowOperationType) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String each : relatedShadowTables) {
            Collection<String> relatedShadowColumnNames = shadowRule.getRelatedShadowColumnNames(shadowOperationType, each);
            if (relatedShadowColumnNames.isEmpty() || !this.isMatchAnyColumnShadowAlgorithms(each, relatedShadowColumnNames, shadowRule, shadowOperationType)) continue;
            return shadowRule.getRelatedShadowDataSourceMappings(each);
        }
        return result;
    }

    private boolean isMatchAnyColumnShadowAlgorithms(String shadowTable, Collection<String> shadowColumnNames, ShadowRule shadowRule, ShadowOperationType shadowOperation) {
        for (String each : shadowColumnNames) {
            if (!this.isMatchAnyColumnShadowAlgorithms(shadowTable, each, shadowOperation, shadowRule)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchAnyColumnShadowAlgorithms(String shadowTable, String shadowColumn, ShadowOperationType shadowOperationType, ShadowRule shadowRule) {
        Collection<ColumnShadowAlgorithm<Comparable<?>>> columnShadowAlgorithms = shadowRule.getRelatedColumnShadowAlgorithms(shadowOperationType, shadowTable, shadowColumn);
        if (columnShadowAlgorithms.isEmpty()) {
            return false;
        }
        Iterator<Optional<ShadowColumnCondition>> iterator = this.getShadowColumnConditionIterator(shadowColumn);
        while (iterator.hasNext()) {
            Optional<ShadowColumnCondition> next = iterator.next();
            if (!next.isPresent()) continue;
            for (ColumnShadowAlgorithm<Comparable<?>> each : columnShadowAlgorithms) {
                ShadowDetermineCondition shadowDetermineCondition;
                if (!ColumnShadowAlgorithmDeterminer.isShadow(each, (shadowDetermineCondition = new ShadowDetermineCondition(shadowTable, shadowOperationType)).initShadowColumnCondition(next.get()))) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract Collection<SimpleTableSegment> getAllTables();

    protected abstract ShadowOperationType getShadowOperationType();

    protected abstract Optional<Collection<String>> parseSQLComments();

    protected abstract Iterator<Optional<ShadowColumnCondition>> getShadowColumnConditionIterator(String var1);

    protected String getSingleTableName() {
        return this.tableAliasNameMappings.entrySet().iterator().next().getValue();
    }

    @Generated
    public Map<String, String> getTableAliasNameMappings() {
        return this.tableAliasNameMappings;
    }
}

