/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Iterator;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.route.engine.util.ShadowExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;

public abstract class AbstractWhereSegmentShadowColumnConditionIterator
implements Iterator<Optional<ShadowColumnCondition>> {
    private final String shadowColumn;
    private final Iterator<ExpressionSegment> iterator;

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Optional<ShadowColumnCondition> next() {
        ExpressionSegment expressionSegment = this.iterator.next();
        Optional<ColumnSegment> columnSegment = ShadowExtractor.extractColumn(expressionSegment);
        if (!columnSegment.isPresent()) {
            return Optional.empty();
        }
        String column = columnSegment.get().getIdentifier().getValue();
        if (!this.shadowColumn.equals(column)) {
            return Optional.empty();
        }
        return this.nextShadowColumnCondition(expressionSegment, columnSegment.get());
    }

    protected abstract Optional<ShadowColumnCondition> nextShadowColumnCondition(ExpressionSegment var1, ColumnSegment var2);

    @Generated
    public AbstractWhereSegmentShadowColumnConditionIterator(String shadowColumn, Iterator<ExpressionSegment> iterator) {
        this.shadowColumn = shadowColumn;
        this.iterator = iterator;
    }

    @Generated
    protected String getShadowColumn() {
        return this.shadowColumn;
    }

    @Generated
    protected Iterator<ExpressionSegment> getIterator() {
        return this.iterator;
    }
}

