/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.exception.syntax.UnsupportedShadowInsertValueException;
import org.apache.shardingsphere.shadow.route.engine.dml.AbstractShadowDMLStatementRouteEngine;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;

public final class ShadowInsertStatementRoutingEngine
extends AbstractShadowDMLStatementRouteEngine {
    private final InsertStatementContext insertStatementContext;

    @Override
    protected Collection<SimpleTableSegment> getAllTables() {
        return this.insertStatementContext.getAllTables();
    }

    @Override
    protected ShadowOperationType getShadowOperationType() {
        return ShadowOperationType.INSERT;
    }

    @Override
    protected Optional<Collection<String>> parseSQLComments() {
        LinkedList result = new LinkedList();
        ((InsertStatement)this.insertStatementContext.getSqlStatement()).getCommentSegments().forEach(each -> result.add(each.getText()));
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @Override
    protected Iterator<Optional<ShadowColumnCondition>> getShadowColumnConditionIterator(String shadowColumn) {
        return new ShadowColumnConditionIterator(shadowColumn, this.parseColumnNames().iterator(), this.insertStatementContext.getInsertValueContexts());
    }

    private Collection<String> parseColumnNames() {
        return this.insertStatementContext.getInsertColumnNames();
    }

    @Generated
    public ShadowInsertStatementRoutingEngine(InsertStatementContext insertStatementContext) {
        this.insertStatementContext = insertStatementContext;
    }

    private class ShadowColumnConditionIterator
    implements Iterator<Optional<ShadowColumnCondition>> {
        private int index = 0;
        private final String shadowColumn;
        private final Iterator<String> iterator;
        private final List<InsertValueContext> insertValueContexts;

        ShadowColumnConditionIterator(String shadowColumn, Iterator<String> iterator, List<InsertValueContext> insertValueContexts) {
            this.shadowColumn = shadowColumn;
            this.iterator = iterator;
            this.insertValueContexts = insertValueContexts;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Optional<ShadowColumnCondition> next() {
            String columnName = this.iterator.next();
            if (!this.shadowColumn.equals(columnName)) {
                ++this.index;
                return Optional.empty();
            }
            Optional<Collection<Comparable<?>>> columnValues = this.getColumnValues(this.insertValueContexts, this.index);
            ++this.index;
            return columnValues.map(each -> new ShadowColumnCondition(ShadowInsertStatementRoutingEngine.this.getSingleTableName(), columnName, (Collection<Comparable<?>>)each));
        }

        private Optional<Collection<Comparable<?>>> getColumnValues(List<InsertValueContext> insertValueContexts, int columnIndex) {
            LinkedList<Comparable> result = new LinkedList<Comparable>();
            for (InsertValueContext each : insertValueContexts) {
                Object valueObject = each.getLiteralValue(columnIndex).orElseThrow(() -> new UnsupportedShadowInsertValueException(columnIndex));
                if (valueObject instanceof Comparable) {
                    result.add((Comparable)valueObject);
                    continue;
                }
                return Optional.empty();
            }
            return result.isEmpty() ? Optional.empty() : Optional.of(result);
        }
    }
}

