/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.route.engine.dml.AbstractShadowDMLStatementRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.dml.AbstractWhereSegmentShadowColumnConditionIterator;
import org.apache.shardingsphere.shadow.route.engine.util.ShadowExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;

public final class ShadowSelectStatementRoutingEngine
extends AbstractShadowDMLStatementRouteEngine {
    private final SelectStatementContext selectStatementContext;
    private final List<Object> parameters;

    @Override
    protected Collection<SimpleTableSegment> getAllTables() {
        return this.selectStatementContext.getAllTables();
    }

    @Override
    protected ShadowOperationType getShadowOperationType() {
        return ShadowOperationType.SELECT;
    }

    @Override
    protected Optional<Collection<String>> parseSQLComments() {
        LinkedList result = new LinkedList();
        ((SelectStatement)this.selectStatementContext.getSqlStatement()).getCommentSegments().forEach(each -> result.add(each.getText()));
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @Override
    protected Iterator<Optional<ShadowColumnCondition>> getShadowColumnConditionIterator(String shadowColumn) {
        return new ShadowColumnConditionIterator(shadowColumn, this.parseWhereSegment());
    }

    private Collection<ExpressionSegment> parseWhereSegment() {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : this.selectStatementContext.getWhereSegments()) {
            for (AndPredicate predicate : ExpressionExtractUtil.getAndPredicates((ExpressionSegment)each.getExpr())) {
                result.addAll(predicate.getPredicates());
            }
        }
        return result;
    }

    @Generated
    public ShadowSelectStatementRoutingEngine(SelectStatementContext selectStatementContext, List<Object> parameters) {
        this.selectStatementContext = selectStatementContext;
        this.parameters = parameters;
    }

    private final class ShadowColumnConditionIterator
    extends AbstractWhereSegmentShadowColumnConditionIterator {
        ShadowColumnConditionIterator(String shadowColumn, Collection<ExpressionSegment> predicates) {
            super(shadowColumn, predicates.iterator());
        }

        @Override
        protected Optional<ShadowColumnCondition> nextShadowColumnCondition(ExpressionSegment expressionSegment, ColumnSegment columnSegment) {
            return ShadowExtractor.extractValues(expressionSegment, ShadowSelectStatementRoutingEngine.this.parameters).map(values -> new ShadowColumnCondition(this.extractOwnerName(columnSegment), this.getShadowColumn(), (Collection<Comparable<?>>)values));
        }

        private String extractOwnerName(ColumnSegment columnSegment) {
            Optional owner = columnSegment.getOwner();
            return owner.isPresent() ? ShadowSelectStatementRoutingEngine.this.getTableAliasNameMappings().get(((OwnerSegment)owner.get()).getIdentifier().getValue()) : ShadowSelectStatementRoutingEngine.this.getTableAliasNameMappings().keySet().iterator().next();
        }
    }
}

