/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.hint.HintShadowAlgorithm;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;
import org.apache.shardingsphere.shadow.route.engine.ShadowRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.determiner.HintShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;

public final class ShadowNonDMLStatementRoutingEngine
implements ShadowRouteEngine {
    private final SQLStatementContext<?> sqlStatementContext;

    @Override
    public void route(RouteContext routeContext, ShadowRule shadowRule) {
        this.decorateRouteContext(routeContext, shadowRule, this.findShadowDataSourceMappings(shadowRule));
    }

    private Map<String, String> findShadowDataSourceMappings(ShadowRule shadowRule) {
        Optional<Collection<String>> sqlComments = this.parseSQLComments();
        if (!sqlComments.isPresent()) {
            return new LinkedHashMap<String, String>();
        }
        if (this.isMatchAnyNoteShadowAlgorithms(shadowRule, this.createShadowDetermineCondition(sqlComments.get()))) {
            return shadowRule.getAllShadowDataSourceMappings();
        }
        return new LinkedHashMap<String, String>();
    }

    private Optional<Collection<String>> parseSQLComments() {
        Collection result = ((AbstractSQLStatement)this.sqlStatementContext.getSqlStatement()).getCommentSegments().stream().map(CommentSegment::getText).collect(Collectors.toList());
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private ShadowDetermineCondition createShadowDetermineCondition(Collection<String> sqlComments) {
        ShadowDetermineCondition result = new ShadowDetermineCondition("", ShadowOperationType.HINT_MATCH);
        return result.initSQLComments(sqlComments);
    }

    private boolean isMatchAnyNoteShadowAlgorithms(ShadowRule shadowRule, ShadowDetermineCondition shadowCondition) {
        for (HintShadowAlgorithm<Comparable<?>> each : shadowRule.getAllHintShadowAlgorithms()) {
            if (!HintShadowAlgorithmDeterminer.isShadow(each, shadowCondition, shadowRule)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public ShadowNonDMLStatementRoutingEngine(SQLStatementContext<?> sqlStatementContext) {
        this.sqlStatementContext = sqlStatementContext;
    }
}

