/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.hint.HintShadowAlgorithm;
import org.apache.shardingsphere.shadow.rule.ShadowAlgorithmNameRule;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

public final class ShadowTableRule {
    private final String tableName;
    private final Collection<String> shadowDataSources;
    private final Collection<String> hintShadowAlgorithmNames;
    private final Map<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> columnShadowAlgorithmNames;

    public ShadowTableRule(String tableName, Collection<String> shadowDataSources, Collection<String> shadowAlgorithmNames, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        this.tableName = tableName;
        this.shadowDataSources = shadowDataSources;
        this.hintShadowAlgorithmNames = this.initHintShadowAlgorithmNames(shadowAlgorithmNames, shadowAlgorithms);
        this.columnShadowAlgorithmNames = this.initColumnShadowAlgorithmNames(shadowAlgorithmNames, shadowAlgorithms);
    }

    private Collection<String> initHintShadowAlgorithmNames(Collection<String> shadowAlgorithmNames, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        return shadowAlgorithmNames.stream().filter(each -> shadowAlgorithms.get(each) instanceof HintShadowAlgorithm).collect(Collectors.toList());
    }

    private Map<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> initColumnShadowAlgorithmNames(Collection<String> shadowAlgorithmNames, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        EnumMap<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> result = new EnumMap<ShadowOperationType, Collection<ShadowAlgorithmNameRule>>(ShadowOperationType.class);
        shadowAlgorithmNames.forEach(each -> {
            ShadowAlgorithm shadowAlgorithm = (ShadowAlgorithm)shadowAlgorithms.get(each);
            if (shadowAlgorithm instanceof ColumnShadowAlgorithm) {
                String operation = shadowAlgorithm.getProps().getProperty("operation");
                String shadowColumnName = shadowAlgorithm.getProps().getProperty("column");
                ShadowOperationType.contains((String)operation).ifPresent(optional -> this.initShadowAlgorithmNames((ShadowOperationType)optional, (String)each, shadowColumnName, (Map<ShadowOperationType, Collection<ShadowAlgorithmNameRule>>)result));
            }
        });
        return result;
    }

    private void initShadowAlgorithmNames(ShadowOperationType operationType, String algorithmName, String shadowColumnName, Map<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> columnShadowAlgorithmNames) {
        Collection<ShadowAlgorithmNameRule> shadowAlgorithmNameRules = columnShadowAlgorithmNames.get(operationType);
        Preconditions.checkState((null == shadowAlgorithmNameRules ? 1 : 0) != 0, (String)"Column shadow algorithm `%s` operation only supports one column mapping in shadow table `%s`.", (Object)operationType.name(), (Object)this.tableName);
        columnShadowAlgorithmNames.put(operationType, Collections.singletonList(new ShadowAlgorithmNameRule(shadowColumnName, algorithmName)));
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public Collection<String> getShadowDataSources() {
        return this.shadowDataSources;
    }

    @Generated
    public Collection<String> getHintShadowAlgorithmNames() {
        return this.hintShadowAlgorithmNames;
    }

    @Generated
    public Map<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> getColumnShadowAlgorithmNames() {
        return this.columnShadowAlgorithmNames;
    }
}

