/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.yaml.swapper;

import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.shadow.algorithm.config.AlgorithmProvidedShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.datasource.YamlShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.table.YamlShadowTableConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.datasource.YamlShadowDataSourceConfigurationSwapper;
import org.apache.shardingsphere.shadow.yaml.swapper.table.YamlShadowTableConfigurationSwapper;

public final class YamlShadowRuleAlgorithmProviderConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlShadowRuleConfiguration, AlgorithmProvidedShadowRuleConfiguration> {
    private final YamlShadowDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlShadowDataSourceConfigurationSwapper();
    private final YamlShadowTableConfigurationSwapper tableSwapper = new YamlShadowTableConfigurationSwapper();

    public YamlShadowRuleConfiguration swapToYamlConfiguration(AlgorithmProvidedShadowRuleConfiguration data) {
        YamlShadowRuleConfiguration result = new YamlShadowRuleConfiguration();
        result.setDefaultShadowAlgorithmName(data.getDefaultShadowAlgorithmName());
        this.parseDataSources(data, result);
        this.parseShadowTables(data, result);
        this.parseShadowAlgorithms(data, result);
        return result;
    }

    private void parseShadowAlgorithms(AlgorithmProvidedShadowRuleConfiguration data, YamlShadowRuleConfiguration yamlConfig) {
        data.getShadowAlgorithms().forEach((key, value) -> yamlConfig.getShadowAlgorithms().put((String)key, new YamlAlgorithmConfiguration(value.getType(), value.getProps())));
    }

    private void parseShadowTables(AlgorithmProvidedShadowRuleConfiguration data, YamlShadowRuleConfiguration yamlConfig) {
        data.getTables().forEach((key, value) -> yamlConfig.getTables().put((String)key, this.tableSwapper.swapToYamlConfiguration((ShadowTableConfiguration)value)));
    }

    private void parseDataSources(AlgorithmProvidedShadowRuleConfiguration data, YamlShadowRuleConfiguration yamlConfig) {
        data.getDataSources().forEach((key, value) -> yamlConfig.getDataSources().put((String)key, this.dataSourceConfigSwapper.swapToYamlConfiguration((ShadowDataSourceConfiguration)value)));
    }

    public AlgorithmProvidedShadowRuleConfiguration swapToObject(YamlShadowRuleConfiguration yamlConfig) {
        AlgorithmProvidedShadowRuleConfiguration result = new AlgorithmProvidedShadowRuleConfiguration();
        result.setDefaultShadowAlgorithmName(yamlConfig.getDefaultShadowAlgorithmName());
        this.parseYamlDataSources(yamlConfig, result);
        this.parseYamlShadowTables(yamlConfig, result);
        return result;
    }

    private void parseYamlShadowTables(YamlShadowRuleConfiguration yamlConfig, AlgorithmProvidedShadowRuleConfiguration data) {
        yamlConfig.getTables().forEach((key, value) -> data.getTables().put((String)key, this.tableSwapper.swapToObject((YamlShadowTableConfiguration)value)));
    }

    private void parseYamlDataSources(YamlShadowRuleConfiguration yamlConfig, AlgorithmProvidedShadowRuleConfiguration data) {
        yamlConfig.getDataSources().forEach((key, value) -> data.getDataSources().put((String)key, this.dataSourceConfigSwapper.swapToObject((YamlShadowDataSourceConfiguration)value)));
    }

    public Class<AlgorithmProvidedShadowRuleConfiguration> getTypeClass() {
        return AlgorithmProvidedShadowRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SHADOW";
    }

    public int getOrder() {
        return 51;
    }
}

