/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cache.checker;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.DeleteStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.cache.api.ShardingCacheOptions;
import org.apache.shardingsphere.sharding.cache.checker.ShardingRouteCacheableCheckResult;
import org.apache.shardingsphere.sharding.cache.checker.algorithm.CacheableShardingAlgorithmChecker;
import org.apache.shardingsphere.sharding.cache.rule.ShardingCacheRule;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.impl.InsertClauseShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.impl.WhereClauseShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;

public final class ShardingRouteCacheableChecker {
    private final ShardingRule shardingRule;
    private final LoadingCache<Key, ShardingRouteCacheableCheckResult> checkingCache;

    public ShardingRouteCacheableChecker(ShardingCacheRule shardingCacheRule) {
        this.shardingRule = shardingCacheRule.getShardingRule();
        this.checkingCache = this.buildCache(shardingCacheRule.getConfiguration().getRouteCache());
    }

    private LoadingCache<Key, ShardingRouteCacheableCheckResult> buildCache(ShardingCacheOptions cacheOptions) {
        Caffeine result = Caffeine.newBuilder().initialCapacity(cacheOptions.getInitialCapacity()).maximumSize((long)cacheOptions.getMaximumSize());
        if (cacheOptions.isSoftValues()) {
            result.softValues();
        }
        return result.build(this::load);
    }

    private ShardingRouteCacheableCheckResult load(Key key) {
        SQLStatementContext<?> sqlStatementContext = key.getSqlStatementContext();
        ShardingRouteCacheableCheckResult result = sqlStatementContext instanceof SelectStatementContext ? this.checkSelectCacheable((SelectStatementContext)sqlStatementContext, key.getParameters(), key.getDatabase()) : (sqlStatementContext instanceof UpdateStatementContext ? this.checkUpdateCacheable((UpdateStatementContext)sqlStatementContext, key.getParameters(), key.getDatabase()) : (sqlStatementContext instanceof InsertStatementContext ? this.checkInsertCacheable((InsertStatementContext)sqlStatementContext, key.getParameters(), key.getDatabase()) : (sqlStatementContext instanceof DeleteStatementContext ? this.checkDeleteCacheable((DeleteStatementContext)sqlStatementContext, key.getParameters(), key.getDatabase()) : new ShardingRouteCacheableCheckResult(false, Collections.emptyList()))));
        key.getParameters().clear();
        return result;
    }

    private ShardingRouteCacheableCheckResult checkSelectCacheable(SelectStatementContext statementContext, List<Object> parameters, ShardingSphereDatabase database) {
        HashSet<String> tableNames = new HashSet<String>(statementContext.getTablesContext().getTableNames());
        if (!this.shardingRule.isAllShardingTables(tableNames) || this.shardingRule.isAllBroadcastTables(tableNames)) {
            return new ShardingRouteCacheableCheckResult(false, Collections.emptyList());
        }
        tableNames.removeAll(this.shardingRule.getBroadcastTables());
        if (1 != tableNames.size() && !this.shardingRule.isAllBindingTables(tableNames) || this.containsNonCacheableShardingAlgorithm(tableNames)) {
            return new ShardingRouteCacheableCheckResult(false, Collections.emptyList());
        }
        List shardingConditions = new WhereClauseShardingConditionEngine(this.shardingRule, database).createShardingConditions((SQLStatementContext)statementContext, parameters);
        return ShardingRouteCacheableChecker.checkShardingConditionsCacheable(shardingConditions);
    }

    private ShardingRouteCacheableCheckResult checkUpdateCacheable(UpdateStatementContext statementContext, List<Object> parameters, ShardingSphereDatabase database) {
        return this.checkUpdateOrDeleteCacheable((SQLStatementContext<?>)statementContext, parameters, database);
    }

    private ShardingRouteCacheableCheckResult checkInsertCacheable(InsertStatementContext statementContext, List<Object> parameters, ShardingSphereDatabase database) {
        boolean isShardingTable;
        Collection tableNames = statementContext.getTablesContext().getTableNames();
        if (1 != tableNames.size() || null != statementContext.getInsertSelectContext() || null != statementContext.getOnDuplicateKeyUpdateValueContext() || statementContext.getGeneratedKeyContext().map(GeneratedKeyContext::isGenerated).orElse(false).booleanValue() || (isShardingTable = this.shardingRule.isAllShardingTables(tableNames)) && this.containsNonCacheableShardingAlgorithm(tableNames) || !isShardingTable && !this.shardingRule.isAllBroadcastTables(tableNames)) {
            return new ShardingRouteCacheableCheckResult(false, Collections.emptyList());
        }
        Collection values = ((InsertStatement)statementContext.getSqlStatement()).getValues();
        if (1 != values.size()) {
            return new ShardingRouteCacheableCheckResult(false, Collections.emptyList());
        }
        InsertValuesSegment valueSegment = (InsertValuesSegment)values.iterator().next();
        for (ExpressionSegment each : valueSegment.getValues()) {
            if (each instanceof ParameterMarkerExpressionSegment || each instanceof LiteralExpressionSegment) continue;
            return new ShardingRouteCacheableCheckResult(false, Collections.emptyList());
        }
        List shardingConditions = new InsertClauseShardingConditionEngine(this.shardingRule, database).createShardingConditions(statementContext, parameters);
        return ShardingRouteCacheableChecker.checkShardingConditionsCacheable(shardingConditions);
    }

    private ShardingRouteCacheableCheckResult checkDeleteCacheable(DeleteStatementContext statementContext, List<Object> parameters, ShardingSphereDatabase database) {
        return this.checkUpdateOrDeleteCacheable((SQLStatementContext<?>)statementContext, parameters, database);
    }

    private ShardingRouteCacheableCheckResult checkUpdateOrDeleteCacheable(SQLStatementContext<?> statementContext, List<Object> parameters, ShardingSphereDatabase database) {
        boolean isShardingTable;
        Collection tableNames = statementContext.getTablesContext().getTableNames();
        if (1 != tableNames.size() || (isShardingTable = this.shardingRule.isAllShardingTables(tableNames)) && this.containsNonCacheableShardingAlgorithm(tableNames) || !isShardingTable && !this.shardingRule.isAllBroadcastTables(tableNames)) {
            return new ShardingRouteCacheableCheckResult(false, Collections.emptyList());
        }
        List shardingConditions = new WhereClauseShardingConditionEngine(this.shardingRule, database).createShardingConditions(statementContext, parameters);
        return ShardingRouteCacheableChecker.checkShardingConditionsCacheable(shardingConditions);
    }

    private boolean containsNonCacheableShardingAlgorithm(Collection<String> logicTables) {
        for (String each : logicTables) {
            TableRule tableRule = this.shardingRule.getTableRule(each);
            String databaseShardingAlgorithmName = this.shardingRule.getDatabaseShardingStrategyConfiguration(tableRule).getShardingAlgorithmName();
            ShardingAlgorithm databaseShardingAlgorithm = (ShardingAlgorithm)this.shardingRule.getShardingAlgorithms().get(databaseShardingAlgorithmName);
            if (null != databaseShardingAlgorithm && !CacheableShardingAlgorithmChecker.isCacheableShardingAlgorithm(databaseShardingAlgorithm)) {
                return true;
            }
            String tableShardingAlgorithmName = this.shardingRule.getTableShardingStrategyConfiguration(tableRule).getShardingAlgorithmName();
            ShardingAlgorithm tableShardingAlgorithm = (ShardingAlgorithm)this.shardingRule.getShardingAlgorithms().get(tableShardingAlgorithmName);
            if (null == tableShardingAlgorithm || CacheableShardingAlgorithmChecker.isCacheableShardingAlgorithm(tableShardingAlgorithm)) continue;
            return true;
        }
        return false;
    }

    private static ShardingRouteCacheableCheckResult checkShardingConditionsCacheable(List<ShardingCondition> shardingConditions) {
        TreeSet result = new TreeSet();
        for (ShardingCondition each : shardingConditions) {
            for (ShardingConditionValue conditionValue : each.getValues()) {
                if (!ShardingRouteCacheableChecker.isConditionTypeCacheable(conditionValue)) {
                    return new ShardingRouteCacheableCheckResult(false, Collections.emptyList());
                }
                result.addAll(conditionValue.getParameterMarkerIndexes());
            }
        }
        return new ShardingRouteCacheableCheckResult(true, new ArrayList<Integer>(result));
    }

    private static boolean isConditionTypeCacheable(ShardingConditionValue conditionValue) {
        if (conditionValue instanceof ListShardingConditionValue) {
            for (Comparable eachValue : ((ListShardingConditionValue)conditionValue).getValues()) {
                if (eachValue instanceof Number) continue;
                return false;
            }
        }
        if (conditionValue instanceof RangeShardingConditionValue) {
            Range range = ((RangeShardingConditionValue)conditionValue).getValueRange();
            return range.lowerEndpoint() instanceof Number && range.upperEndpoint() instanceof Number;
        }
        return true;
    }

    public ShardingRouteCacheableCheckResult check(ShardingSphereDatabase database, QueryContext queryContext) {
        return (ShardingRouteCacheableCheckResult)this.checkingCache.get((Object)new Key(database, queryContext.getSql(), queryContext.getSqlStatementContext(), queryContext.getParameters()));
    }

    private static class Key {
        private final ShardingSphereDatabase database;
        private final String sql;
        private final SQLStatementContext<?> sqlStatementContext;
        private final List<Object> parameters;

        Key(ShardingSphereDatabase database, String sql, SQLStatementContext<?> sqlStatementContext, List<Object> parameters) {
            this.database = database;
            this.sql = sql;
            this.sqlStatementContext = sqlStatementContext;
            this.parameters = new ArrayList<Object>(parameters);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            return result;
        }

        @Generated
        public ShardingSphereDatabase getDatabase() {
            return this.database;
        }

        @Generated
        public String getSql() {
            return this.sql;
        }

        @Generated
        public SQLStatementContext<?> getSqlStatementContext() {
            return this.sqlStatementContext;
        }

        @Generated
        public List<Object> getParameters() {
            return this.parameters;
        }
    }
}

