/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.keygen;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.InstanceContextAware;
import org.apache.shardingsphere.sharding.algorithm.keygen.TimeService;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;

public final class SnowflakeKeyGenerateAlgorithm
implements KeyGenerateAlgorithm,
InstanceContextAware {
    public static final long EPOCH;
    private static final String MAX_VIBRATION_OFFSET_KEY = "max-vibration-offset";
    private static final String MAX_TOLERATE_TIME_DIFFERENCE_MILLISECONDS_KEY = "max-tolerate-time-difference-milliseconds";
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final long WORKER_ID_LEFT_SHIFT_BITS = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT_BITS = 22L;
    private static final int DEFAULT_VIBRATION_VALUE = 1;
    private static final int MAX_TOLERATE_TIME_DIFFERENCE_MILLISECONDS = 10;
    private static final long DEFAULT_WORKER_ID = 0L;
    private static TimeService timeService;
    private Properties props;
    private int maxVibrationOffset;
    private int maxTolerateTimeDifferenceMilliseconds;
    private volatile int sequenceOffset = -1;
    private volatile long sequence;
    private volatile long lastMilliseconds;
    private volatile InstanceContext instanceContext;

    public void init(Properties props) {
        this.props = props;
        this.maxVibrationOffset = this.getMaxVibrationOffset(props);
        this.maxTolerateTimeDifferenceMilliseconds = this.getMaxTolerateTimeDifferenceMilliseconds(props);
    }

    public void setInstanceContext(InstanceContext instanceContext) {
        this.instanceContext = instanceContext;
        if (null != instanceContext) {
            instanceContext.generateWorkerId(this.props);
        }
    }

    private int getMaxVibrationOffset(Properties props) {
        int result = Integer.parseInt(props.getOrDefault((Object)MAX_VIBRATION_OFFSET_KEY, (Object)1).toString());
        Preconditions.checkArgument((result >= 0 && (long)result <= 4095L ? 1 : 0) != 0, (Object)"Illegal max vibration offset.");
        return result;
    }

    private int getMaxTolerateTimeDifferenceMilliseconds(Properties props) {
        return Integer.parseInt(props.getOrDefault((Object)MAX_TOLERATE_TIME_DIFFERENCE_MILLISECONDS_KEY, (Object)10).toString());
    }

    public synchronized Long generateKey() {
        long currentMilliseconds = timeService.getCurrentMillis();
        if (this.waitTolerateTimeDifferenceIfNeed(currentMilliseconds)) {
            currentMilliseconds = timeService.getCurrentMillis();
        }
        if (this.lastMilliseconds == currentMilliseconds) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (0L == this.sequence) {
                currentMilliseconds = this.waitUntilNextTime(currentMilliseconds);
            }
        } else {
            this.vibrateSequenceOffset();
            this.sequence = this.sequenceOffset;
        }
        this.lastMilliseconds = currentMilliseconds;
        return currentMilliseconds - EPOCH << 22 | this.getWorkerId() << 12 | this.sequence;
    }

    private boolean waitTolerateTimeDifferenceIfNeed(long currentMilliseconds) {
        if (this.lastMilliseconds <= currentMilliseconds) {
            return false;
        }
        long timeDifferenceMilliseconds = this.lastMilliseconds - currentMilliseconds;
        Preconditions.checkState((timeDifferenceMilliseconds < (long)this.maxTolerateTimeDifferenceMilliseconds ? 1 : 0) != 0, (String)"Clock is moving backwards, last time is %d milliseconds, current time is %d milliseconds", (long)this.lastMilliseconds, (long)currentMilliseconds);
        Thread.sleep(timeDifferenceMilliseconds);
        return true;
    }

    private long waitUntilNextTime(long lastTime) {
        long result = timeService.getCurrentMillis();
        while (result <= lastTime) {
            result = timeService.getCurrentMillis();
        }
        return result;
    }

    private void vibrateSequenceOffset() {
        this.sequenceOffset = this.sequenceOffset >= this.maxVibrationOffset ? 0 : this.sequenceOffset + 1;
    }

    private long getWorkerId() {
        return null == this.instanceContext ? 0L : this.instanceContext.getWorkerId();
    }

    public String getType() {
        return "SNOWFLAKE";
    }

    public boolean isDefault() {
        return true;
    }

    @Generated
    public static void setTimeService(TimeService timeService) {
        SnowflakeKeyGenerateAlgorithm.timeService = timeService;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    static {
        timeService = new TimeService();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 10, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        EPOCH = calendar.getTimeInMillis();
    }
}

