/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.complex;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.util.Expando;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.util.expr.InlineExpressionParser;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingValue;

public final class ComplexInlineShardingAlgorithm
implements ComplexKeysShardingAlgorithm<Comparable<?>> {
    private static final String ALGORITHM_EXPRESSION_KEY = "algorithm-expression";
    private static final String SHARING_COLUMNS_KEY = "sharding-columns";
    private static final String ALLOW_RANGE_QUERY_KEY = "allow-range-query-with-inline-sharding";
    private Properties props;
    private String algorithmExpression;
    private Collection<String> shardingColumns;
    private boolean allowRangeQuery;

    public void init(Properties props) {
        this.props = props;
        this.algorithmExpression = this.getAlgorithmExpression(props);
        this.shardingColumns = this.getShardingColumns(props);
        this.allowRangeQuery = this.getAllowRangeQuery(props);
    }

    private String getAlgorithmExpression(Properties props) {
        String algorithmExpression = props.getProperty(ALGORITHM_EXPRESSION_KEY);
        Preconditions.checkNotNull((Object)algorithmExpression, (Object)"Inline sharding algorithm expression can not be null.");
        return InlineExpressionParser.handlePlaceHolder((String)algorithmExpression.trim());
    }

    private Collection<String> getShardingColumns(Properties props) {
        String shardingColumns = props.getProperty(SHARING_COLUMNS_KEY, "");
        return shardingColumns.isEmpty() ? Collections.emptyList() : Arrays.asList(shardingColumns.split(","));
    }

    private boolean getAllowRangeQuery(Properties props) {
        return Boolean.parseBoolean(props.getOrDefault((Object)ALLOW_RANGE_QUERY_KEY, Boolean.FALSE.toString()).toString());
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, ComplexKeysShardingValue<Comparable<?>> shardingValue) {
        if (!shardingValue.getColumnNameAndRangeValuesMap().isEmpty()) {
            ShardingSpherePreconditions.checkState((boolean)this.allowRangeQuery, () -> new UnsupportedSQLOperationException(String.format("Since the property of `%s` is false, inline sharding algorithm can not tackle with range query", ALLOW_RANGE_QUERY_KEY)));
            return availableTargetNames;
        }
        Map columnNameAndShardingValuesMap = shardingValue.getColumnNameAndShardingValuesMap();
        Preconditions.checkArgument((this.shardingColumns.isEmpty() || this.shardingColumns.size() == columnNameAndShardingValuesMap.size() ? 1 : 0) != 0, (String)"Complex inline need %s sharing columns, but only found %s", (int)this.shardingColumns.size(), (int)columnNameAndShardingValuesMap.size());
        Collection combine = ComplexInlineShardingAlgorithm.combine(columnNameAndShardingValuesMap);
        return combine.stream().map(this::doSharding).collect(Collectors.toList());
    }

    private String doSharding(Map<String, Comparable<?>> shardingValues) {
        Closure<?> closure = this.createClosure();
        for (Map.Entry<String, Comparable<?>> entry : shardingValues.entrySet()) {
            closure.setProperty(entry.getKey(), entry.getValue());
        }
        return closure.call().toString();
    }

    private static <K, V> Collection<Map<K, V>> combine(Map<K, Collection<V>> map) {
        LinkedList<Map<K, V>> result = new LinkedList<Map<K, V>>();
        for (Map.Entry<K, Collection<V>> entry : map.entrySet()) {
            if (result.isEmpty()) {
                for (V value : entry.getValue()) {
                    HashMap<K, V> hashMap = new HashMap<K, V>();
                    hashMap.put(entry.getKey(), value);
                    result.add(hashMap);
                }
                continue;
            }
            LinkedList list = new LinkedList();
            for (Map map2 : result) {
                for (V value : entry.getValue()) {
                    HashMap<K, V> item = new HashMap<K, V>();
                    item.put(entry.getKey(), value);
                    item.putAll(map2);
                    list.add(item);
                }
            }
            result = list;
        }
        return result;
    }

    private Closure<?> createClosure() {
        Closure result = new InlineExpressionParser(this.algorithmExpression).evaluateClosure().rehydrate((Object)new Expando(), null, null);
        result.setResolveStrategy(3);
        return result;
    }

    public String getType() {
        return "COMPLEX_INLINE";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

