/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.hint;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.util.Expando;
import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.expr.InlineExpressionParser;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingValue;

public final class HintInlineShardingAlgorithm
implements HintShardingAlgorithm<Comparable<?>> {
    private static final String ALGORITHM_EXPRESSION_KEY = "algorithm-expression";
    private static final String DEFAULT_ALGORITHM_EXPRESSION = "${value}";
    private static final String HINT_INLINE_VALUE_PROPERTY_NAME = "value";
    private Properties props = new Properties();
    private String algorithmExpression;

    public void init(Properties props) {
        this.props = props;
        this.algorithmExpression = this.getAlgorithmExpression(props);
    }

    private String getAlgorithmExpression(Properties props) {
        String algorithmExpression = props.getProperty(ALGORITHM_EXPRESSION_KEY, DEFAULT_ALGORITHM_EXPRESSION);
        Preconditions.checkNotNull((Object)algorithmExpression, (Object)"Inline sharding algorithm expression can not be null.");
        return InlineExpressionParser.handlePlaceHolder((String)algorithmExpression.trim());
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, HintShardingValue<Comparable<?>> shardingValue) {
        return shardingValue.getValues().isEmpty() ? availableTargetNames : (Collection)shardingValue.getValues().stream().map(this::doSharding).collect(Collectors.toList());
    }

    private String doSharding(Comparable<?> shardingValue) {
        Closure<?> closure = this.createClosure();
        closure.setProperty(HINT_INLINE_VALUE_PROPERTY_NAME, shardingValue);
        return closure.call().toString();
    }

    private Closure<?> createClosure() {
        Closure result = new InlineExpressionParser(this.algorithmExpression).evaluateClosure().rehydrate((Object)new Expando(), null, null);
        result.setResolveStrategy(3);
        return result;
    }

    public String getType() {
        return "HINT_INLINE";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

