/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.mod;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.sharding.algorithm.sharding.ShardingAutoTableAlgorithmUtil;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class HashModShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ShardingAutoTableAlgorithm {
    private static final String SHARDING_COUNT_KEY = "sharding-count";
    private Properties props;
    private int shardingCount;

    public void init(Properties props) {
        this.props = props;
        this.shardingCount = this.getShardingCount(props);
    }

    private int getShardingCount(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey(SHARDING_COUNT_KEY), (Object)"Sharding count cannot be null.");
        return Integer.parseInt(props.getProperty(SHARDING_COUNT_KEY));
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        String suffix = String.valueOf(this.hashShardingValue(shardingValue.getValue()) % (long)this.shardingCount);
        return ShardingAutoTableAlgorithmUtil.findMatchedTargetName(availableTargetNames, suffix, shardingValue.getDataNodeInfo()).orElse(null);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        return availableTargetNames;
    }

    private long hashShardingValue(Comparable<?> shardingValue) {
        return Math.abs((long)shardingValue.hashCode());
    }

    public int getAutoTablesAmount() {
        return this.shardingCount;
    }

    public String getType() {
        return "HASH_MOD";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

