/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.mod;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.sharding.algorithm.sharding.ShardingAutoTableAlgorithmUtil;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class ModShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ShardingAutoTableAlgorithm {
    private static final String SHARDING_COUNT_KEY = "sharding-count";
    private static final String START_OFFSET_INDEX_KEY = "start-offset";
    private static final String STOP_OFFSET_INDEX_KEY = "stop-offset";
    private static final String ZERO_PADDING_KEY = "zero-padding";
    private Properties props;
    private int shardingCount;
    private int startOffset;
    private int stopOffset;
    private boolean zeroPadding;
    private int maxPaddingSize;

    public void init(Properties props) {
        this.props = props;
        this.shardingCount = this.getShardingCount(props);
        this.startOffset = this.getStartOffset(props);
        this.stopOffset = this.getStopOffset(props);
        this.zeroPadding = this.isZeroPadding(props);
        this.maxPaddingSize = this.calculateMaxPaddingSize();
    }

    private int getShardingCount(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey(SHARDING_COUNT_KEY), (Object)"Sharding count can not be null.");
        return Integer.parseInt(props.getProperty(SHARDING_COUNT_KEY));
    }

    private int getStartOffset(Properties props) {
        return Integer.parseInt(String.valueOf(props.getProperty(START_OFFSET_INDEX_KEY, "0")));
    }

    private int getStopOffset(Properties props) {
        return Integer.parseInt(String.valueOf(props.getProperty(STOP_OFFSET_INDEX_KEY, "0")));
    }

    private boolean isZeroPadding(Properties props) {
        return Boolean.parseBoolean(String.valueOf(props.getProperty(ZERO_PADDING_KEY, Boolean.FALSE.toString())));
    }

    private int calculateMaxPaddingSize() {
        int result = 0;
        for (int calculatingShardingCount = this.shardingCount - 1; 0 != calculatingShardingCount; calculatingShardingCount /= 10) {
            ++result;
        }
        return Math.max(result, 1);
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        String shardingResultSuffix = this.getShardingResultSuffix(this.cutShardingValue(shardingValue.getValue()).mod(new BigInteger(String.valueOf(this.shardingCount))).toString());
        return ShardingAutoTableAlgorithmUtil.findMatchedTargetName(availableTargetNames, shardingResultSuffix, shardingValue.getDataNodeInfo()).orElse(null);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        return this.containsAllTargets(shardingValue) ? availableTargetNames : this.getAvailableTargetNames(availableTargetNames, shardingValue);
    }

    private boolean containsAllTargets(RangeShardingValue<Comparable<?>> shardingValue) {
        return !shardingValue.getValueRange().hasUpperBound() || shardingValue.getValueRange().hasLowerBound() && this.getBigInteger(shardingValue.getValueRange().upperEndpoint()).subtract(this.getBigInteger(shardingValue.getValueRange().lowerEndpoint())).intValue() >= this.shardingCount - 1;
    }

    private Collection<String> getAvailableTargetNames(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(availableTargetNames.size());
        BigInteger lower = new BigInteger(shardingValue.getValueRange().lowerEndpoint().toString());
        BigInteger upper = new BigInteger(shardingValue.getValueRange().upperEndpoint().toString());
        BigInteger shardingCountBigInter = new BigInteger(String.valueOf(this.shardingCount));
        BigInteger i = lower;
        while (i.compareTo(upper) <= 0) {
            String shardingResultSuffix = this.getShardingResultSuffix(String.valueOf(i.mod(shardingCountBigInter)));
            ShardingAutoTableAlgorithmUtil.findMatchedTargetName(availableTargetNames, shardingResultSuffix, shardingValue.getDataNodeInfo()).ifPresent(result::add);
            i = i.add(new BigInteger("1"));
        }
        return result;
    }

    private String getShardingResultSuffix(String shardingResultSuffix) {
        return this.zeroPadding ? this.fillZero(shardingResultSuffix) : shardingResultSuffix;
    }

    private String fillZero(String value) {
        return String.format("%0" + this.maxPaddingSize + "d", Integer.parseInt(value));
    }

    private BigInteger cutShardingValue(Comparable<?> shardingValue) {
        this.checkOffsetArgument(shardingValue);
        return 0 == this.startOffset && 0 == this.stopOffset ? this.getBigInteger(shardingValue) : new BigInteger(shardingValue.toString().substring(this.startOffset, shardingValue.toString().length() - this.stopOffset));
    }

    private void checkOffsetArgument(Comparable<?> shardingValue) {
        Preconditions.checkArgument((this.startOffset >= 0 ? 1 : 0) != 0, (Object)"Start offset can not be less than 0.");
        Preconditions.checkArgument((this.stopOffset >= 0 ? 1 : 0) != 0, (Object)"Stop offset can not be less than 0.");
        Preconditions.checkArgument((shardingValue.toString().length() - this.stopOffset > this.startOffset ? 1 : 0) != 0, (Object)"Sharding value subtract stop offset can not be less than start offset.");
    }

    private BigInteger getBigInteger(Comparable<?> value) {
        return value instanceof Number ? BigInteger.valueOf(((Number)((Object)value)).longValue()) : new BigInteger(value.toString());
    }

    public int getAutoTablesAmount() {
        return this.shardingCount;
    }

    public String getType() {
        return "MOD";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

