/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;

public abstract class AbstractShardingRuleConfigurationChecker<T extends RuleConfiguration>
implements RuleConfigurationChecker<T> {
    public final void check(String databaseName, T config, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules) {
        Collection<String> keyGenerators = this.getKeyGenerators(config);
        Collection<String> auditors = this.getAuditors(config);
        Collection<String> shardingAlgorithms = this.getShardingAlgorithms(config);
        this.checkTableConfiguration(databaseName, this.getTables(config), this.getAutoTables(config), keyGenerators, auditors, shardingAlgorithms);
        this.checkKeyGenerateStrategy(databaseName, this.getDefaultKeyGenerateStrategy(config), keyGenerators);
        this.checkAuditStrategy(databaseName, this.getDefaultAuditStrategy(config), auditors);
        this.checkShardingStrategy(databaseName, this.getDefaultDatabaseShardingStrategy(config), shardingAlgorithms);
        this.checkShardingStrategy(databaseName, this.getDefaultTableShardingStrategy(config), shardingAlgorithms);
    }

    private void checkTableConfiguration(String databaseName, Collection<ShardingTableRuleConfiguration> tables, Collection<ShardingAutoTableRuleConfiguration> autoTables, Collection<String> keyGenerators, Collection<String> auditors, Collection<String> shardingAlgorithms) {
        for (ShardingTableRuleConfiguration shardingTableRuleConfiguration : tables) {
            this.checkKeyGenerateStrategy(databaseName, shardingTableRuleConfiguration.getKeyGenerateStrategy(), keyGenerators);
            this.checkAuditStrategy(databaseName, shardingTableRuleConfiguration.getAuditStrategy(), auditors);
            this.checkShardingStrategy(databaseName, shardingTableRuleConfiguration.getDatabaseShardingStrategy(), shardingAlgorithms);
            this.checkShardingStrategy(databaseName, shardingTableRuleConfiguration.getTableShardingStrategy(), shardingAlgorithms);
        }
        for (ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfiguration : autoTables) {
            this.checkKeyGenerateStrategy(databaseName, shardingAutoTableRuleConfiguration.getKeyGenerateStrategy(), keyGenerators);
            this.checkAuditStrategy(databaseName, shardingAutoTableRuleConfiguration.getAuditStrategy(), auditors);
            this.checkShardingStrategy(databaseName, shardingAutoTableRuleConfiguration.getShardingStrategy(), shardingAlgorithms);
        }
    }

    private void checkKeyGenerateStrategy(String databaseName, KeyGenerateStrategyConfiguration keyGenerateStrategy, Collection<String> keyGenerators) {
        if (null == keyGenerateStrategy) {
            return;
        }
        Preconditions.checkState((boolean)keyGenerators.contains(keyGenerateStrategy.getKeyGeneratorName()), (String)"Can not find keyGenerator `%s` in database `%s`.", (Object)keyGenerateStrategy.getKeyGeneratorName(), (Object)databaseName);
    }

    private void checkAuditStrategy(String databaseName, ShardingAuditStrategyConfiguration auditStrategy, Collection<String> auditors) {
        if (null == auditStrategy) {
            return;
        }
        Preconditions.checkState((boolean)auditors.containsAll(auditStrategy.getAuditorNames()), (String)"Can not find all auditors `%s` in database `%s`.", (Object)auditStrategy.getAuditorNames(), (Object)databaseName);
    }

    private void checkShardingStrategy(String databaseName, ShardingStrategyConfiguration shardingStrategy, Collection<String> shardingAlgorithms) {
        if (null == shardingStrategy || shardingStrategy instanceof NoneShardingStrategyConfiguration) {
            return;
        }
        Preconditions.checkState((boolean)shardingAlgorithms.contains(shardingStrategy.getShardingAlgorithmName()), (String)"Can not find shardingAlgorithm `%s` in database `%s`.", (Object)shardingStrategy.getShardingAlgorithmName(), (Object)databaseName);
    }

    protected abstract Collection<String> getKeyGenerators(T var1);

    protected abstract Collection<String> getAuditors(T var1);

    protected abstract Collection<String> getShardingAlgorithms(T var1);

    protected abstract Collection<ShardingTableRuleConfiguration> getTables(T var1);

    protected abstract Collection<ShardingAutoTableRuleConfiguration> getAutoTables(T var1);

    protected abstract KeyGenerateStrategyConfiguration getDefaultKeyGenerateStrategy(T var1);

    protected abstract ShardingAuditStrategyConfiguration getDefaultAuditStrategy(T var1);

    protected abstract ShardingStrategyConfiguration getDefaultDatabaseShardingStrategy(T var1);

    protected abstract ShardingStrategyConfiguration getDefaultTableShardingStrategy(T var1);
}

