/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.checker.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.check.SQLCheckResult;
import org.apache.shardingsphere.infra.executor.check.SQLChecker;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingAuditChecker
implements SQLChecker<ShardingRule> {
    public boolean check(String databaseName, Grantee grantee, ShardingRule rule) {
        return true;
    }

    public SQLCheckResult check(SQLStatementContext<?> sqlStatementContext, List<Object> parameters, Grantee grantee, String currentDatabase, Map<String, ShardingSphereDatabase> databases, ShardingRule rule) {
        Collection<ShardingAuditStrategyConfiguration> auditStrategies = this.getShardingAuditStrategies(sqlStatementContext, rule);
        if (auditStrategies.isEmpty()) {
            return new SQLCheckResult(true, "");
        }
        List disableAuditNames = sqlStatementContext instanceof CommonSQLStatementContext ? ((CommonSQLStatementContext)sqlStatementContext).getSqlHintExtractor().findDisableAuditNames() : Collections.emptyList();
        for (ShardingAuditStrategyConfiguration auditStrategy : auditStrategies) {
            for (String auditorName : auditStrategy.getAuditorNames()) {
                SQLCheckResult result;
                if (auditStrategy.isAllowHintDisable() && disableAuditNames.contains(auditorName.toLowerCase()) || (result = rule.getAuditors().get(auditorName).check(sqlStatementContext, parameters, grantee, databases.get(currentDatabase.toLowerCase()))).isPassed()) continue;
                return result;
            }
        }
        return new SQLCheckResult(true, "");
    }

    public boolean check(Grantee grantee, ShardingRule rule) {
        return true;
    }

    public boolean check(Grantee grantee, BiPredicate<Object, Object> validator, Object cipher, ShardingRule rule) {
        return true;
    }

    private Collection<ShardingAuditStrategyConfiguration> getShardingAuditStrategies(SQLStatementContext<?> sqlStatementContext, ShardingRule rule) {
        Collection tableNames = sqlStatementContext.getTablesContext().getTableNames();
        ArrayList<ShardingAuditStrategyConfiguration> result = new ArrayList<ShardingAuditStrategyConfiguration>(tableNames.size());
        for (String each : tableNames) {
            rule.findTableRule(each).ifPresent(tableRule -> result.add(rule.getAuditStrategyConfiguration((TableRule)tableRule)));
        }
        return result;
    }

    public int getOrder() {
        return -10;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

