/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.exception.metadata;

import java.util.Collection;
import org.apache.shardingsphere.infra.util.exception.external.sql.sqlstate.SQLState;
import org.apache.shardingsphere.infra.util.exception.external.sql.sqlstate.XOpenSQLState;
import org.apache.shardingsphere.sharding.exception.ShardingSQLException;
import org.apache.shardingsphere.sharding.metadata.TableMetaDataViolation;

public final class InconsistentShardingTableMetaDataException
extends ShardingSQLException {
    private static final long serialVersionUID = -5450346946223396192L;

    public InconsistentShardingTableMetaDataException(String logicTableName, Collection<TableMetaDataViolation> violations) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 1, InconsistentShardingTableMetaDataException.createReason(violations), logicTableName);
    }

    private static String createReason(Collection<TableMetaDataViolation> violations) {
        StringBuilder result = new StringBuilder("Can not get uniformed table structure for logic table `%s`, it has different meta data of actual tables are as follows: ").append(System.lineSeparator());
        for (TableMetaDataViolation each : violations) {
            result.append("actual table: ").append(each.getActualTableName()).append(", meta data: ").append(each.getTableMetaData()).append(System.lineSeparator());
        }
        return result.toString();
    }
}

