/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.groupby;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.sharding.merge.dql.groupby.GroupByRowComparator;
import org.apache.shardingsphere.sharding.merge.dql.groupby.GroupByValue;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.AggregationUnit;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.AggregationUnitFactory;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class GroupByMemoryMergedResult
extends MemoryMergedResult<ShardingRule> {
    public GroupByMemoryMergedResult(List<QueryResult> queryResults, SelectStatementContext selectStatementContext, ShardingSphereSchema schema) throws SQLException {
        super(null, schema, (SQLStatementContext)selectStatementContext, queryResults);
    }

    protected List<MemoryQueryResultRow> init(ShardingRule shardingRule, ShardingSphereSchema schema, SQLStatementContext<?> sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        SelectStatementContext selectStatementContext = (SelectStatementContext)sqlStatementContext;
        HashMap<GroupByValue, MemoryQueryResultRow> dataMap = new HashMap<GroupByValue, MemoryQueryResultRow>(1024);
        HashMap<GroupByValue, Map<AggregationProjection, AggregationUnit>> aggregationMap = new HashMap<GroupByValue, Map<AggregationProjection, AggregationUnit>>(1024);
        for (QueryResult each : queryResults) {
            while (each.next()) {
                GroupByValue groupByValue = new GroupByValue(each, selectStatementContext.getGroupByContext().getItems());
                this.initForFirstGroupByValue(selectStatementContext, each, groupByValue, dataMap, aggregationMap);
                this.aggregate(selectStatementContext, each, groupByValue, aggregationMap);
            }
        }
        this.setAggregationValueToMemoryRow(selectStatementContext, dataMap, aggregationMap);
        List<Boolean> valueCaseSensitive = queryResults.isEmpty() ? Collections.emptyList() : this.getValueCaseSensitive(queryResults.iterator().next(), selectStatementContext, schema);
        return this.getMemoryResultSetRows(selectStatementContext, dataMap, valueCaseSensitive);
    }

    private void initForFirstGroupByValue(SelectStatementContext selectStatementContext, QueryResult queryResult, GroupByValue groupByValue, Map<GroupByValue, MemoryQueryResultRow> dataMap, Map<GroupByValue, Map<AggregationProjection, AggregationUnit>> aggregationMap) throws SQLException {
        if (!dataMap.containsKey(groupByValue)) {
            dataMap.put(groupByValue, new MemoryQueryResultRow(queryResult));
        }
        if (!aggregationMap.containsKey(groupByValue)) {
            ImmutableMap map = Maps.toMap((Iterable)selectStatementContext.getProjectionsContext().getAggregationProjections(), input -> AggregationUnitFactory.create(input.getType(), input instanceof AggregationDistinctProjection));
            aggregationMap.put(groupByValue, (Map<AggregationProjection, AggregationUnit>)map);
        }
    }

    private void aggregate(SelectStatementContext selectStatementContext, QueryResult queryResult, GroupByValue groupByValue, Map<GroupByValue, Map<AggregationProjection, AggregationUnit>> aggregationMap) throws SQLException {
        for (AggregationProjection each : selectStatementContext.getProjectionsContext().getAggregationProjections()) {
            ArrayList values = new ArrayList(2);
            if (each.getDerivedAggregationProjections().isEmpty()) {
                values.add(this.getAggregationValue(queryResult, each));
            } else {
                for (AggregationProjection derived : each.getDerivedAggregationProjections()) {
                    values.add(this.getAggregationValue(queryResult, derived));
                }
            }
            aggregationMap.get(groupByValue).get(each).merge(values);
        }
    }

    private Comparable<?> getAggregationValue(QueryResult queryResult, AggregationProjection aggregationProjection) throws SQLException {
        Object result = queryResult.getValue(aggregationProjection.getIndex(), Object.class);
        Preconditions.checkState((null == result || result instanceof Comparable ? 1 : 0) != 0, (Object)"Aggregation value must implements Comparable");
        return (Comparable)result;
    }

    private void setAggregationValueToMemoryRow(SelectStatementContext selectStatementContext, Map<GroupByValue, MemoryQueryResultRow> dataMap, Map<GroupByValue, Map<AggregationProjection, AggregationUnit>> aggregationMap) {
        for (Map.Entry<GroupByValue, MemoryQueryResultRow> entry : dataMap.entrySet()) {
            for (AggregationProjection each : selectStatementContext.getProjectionsContext().getAggregationProjections()) {
                entry.getValue().setCell(each.getIndex(), aggregationMap.get(entry.getKey()).get(each).getResult());
            }
        }
    }

    private List<Boolean> getValueCaseSensitive(QueryResult queryResult, SelectStatementContext selectStatementContext, ShardingSphereSchema schema) throws SQLException {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        result.add(false);
        for (int columnIndex = 1; columnIndex <= queryResult.getMetaData().getColumnCount(); ++columnIndex) {
            result.add(this.getValueCaseSensitiveFromTables(queryResult, selectStatementContext, schema, columnIndex));
        }
        return result;
    }

    private boolean getValueCaseSensitiveFromTables(QueryResult queryResult, SelectStatementContext selectStatementContext, ShardingSphereSchema schema, int columnIndex) throws SQLException {
        for (SimpleTableSegment each : selectStatementContext.getAllTables()) {
            String columnName;
            String tableName = each.getTableName().getIdentifier().getValue();
            ShardingSphereTable table = schema.getTable(tableName);
            Map columns = table.getColumns();
            if (!columns.containsKey(columnName = queryResult.getMetaData().getColumnName(columnIndex))) continue;
            return ((ShardingSphereColumn)columns.get(columnName)).isCaseSensitive();
        }
        return false;
    }

    private List<MemoryQueryResultRow> getMemoryResultSetRows(SelectStatementContext selectStatementContext, Map<GroupByValue, MemoryQueryResultRow> dataMap, List<Boolean> valueCaseSensitive) {
        if (dataMap.isEmpty()) {
            Object[] data = this.generateReturnData(selectStatementContext);
            return Arrays.stream(data).anyMatch(Objects::nonNull) ? Collections.singletonList(new MemoryQueryResultRow(data)) : Collections.emptyList();
        }
        ArrayList<MemoryQueryResultRow> result = new ArrayList<MemoryQueryResultRow>(dataMap.values());
        result.sort(new GroupByRowComparator(selectStatementContext, valueCaseSensitive));
        return result;
    }

    private Object[] generateReturnData(SelectStatementContext selectStatementContext) {
        LinkedList projections = new LinkedList(selectStatementContext.getProjectionsContext().getExpandProjections());
        Object[] result = new Object[projections.size()];
        for (int i = 0; i < projections.size(); ++i) {
            if (!(projections.get(i) instanceof AggregationProjection) || AggregationType.COUNT != ((AggregationProjection)projections.get(i)).getType()) continue;
            result[i] = 0;
        }
        return result;
    }
}

