/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.orderby;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.sharding.merge.dql.orderby.CompareUtil;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class OrderByValue
implements Comparable<OrderByValue> {
    private final QueryResult queryResult;
    private final Collection<OrderByItem> orderByItems;
    private final List<Boolean> orderValuesCaseSensitive;
    private List<Comparable<?>> orderValues;

    public OrderByValue(QueryResult queryResult, Collection<OrderByItem> orderByItems, SelectStatementContext selectStatementContext, ShardingSphereSchema schema) throws SQLException {
        this.queryResult = queryResult;
        this.orderByItems = orderByItems;
        this.orderValuesCaseSensitive = this.getOrderValuesCaseSensitive(selectStatementContext, schema);
    }

    private List<Boolean> getOrderValuesCaseSensitive(SelectStatementContext selectStatementContext, ShardingSphereSchema schema) throws SQLException {
        ArrayList<Boolean> result = new ArrayList<Boolean>(this.orderByItems.size());
        for (OrderByItem eachOrderByItem : this.orderByItems) {
            result.add(this.getOrderValuesCaseSensitiveFromTables(selectStatementContext, schema, eachOrderByItem));
        }
        return result;
    }

    private boolean getOrderValuesCaseSensitiveFromTables(SelectStatementContext selectStatementContext, ShardingSphereSchema schema, OrderByItem eachOrderByItem) throws SQLException {
        for (SimpleTableSegment eachSimpleTableSegment : selectStatementContext.getAllTables()) {
            String tableName = eachSimpleTableSegment.getTableName().getIdentifier().getValue();
            ShardingSphereTable table = schema.getTable(tableName);
            Map columns = table.getColumns();
            OrderByItemSegment orderByItemSegment = eachOrderByItem.getSegment();
            if (orderByItemSegment instanceof ColumnOrderByItemSegment) {
                String columnName = ((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getIdentifier().getValue();
                if (!columns.containsKey(columnName)) continue;
                return ((ShardingSphereColumn)columns.get(columnName)).isCaseSensitive();
            }
            if (orderByItemSegment instanceof IndexOrderByItemSegment) {
                int columnIndex = ((IndexOrderByItemSegment)orderByItemSegment).getColumnIndex();
                String columnName = this.queryResult.getMetaData().getColumnName(columnIndex);
                if (!columns.containsKey(columnName)) continue;
                return ((ShardingSphereColumn)columns.get(columnName)).isCaseSensitive();
            }
            return false;
        }
        return false;
    }

    public boolean next() throws SQLException {
        boolean result = this.queryResult.next();
        this.orderValues = result ? this.getOrderValues() : Collections.emptyList();
        return result;
    }

    private List<Comparable<?>> getOrderValues() throws SQLException {
        ArrayList result = new ArrayList(this.orderByItems.size());
        for (OrderByItem each : this.orderByItems) {
            Object value = this.queryResult.getValue(each.getIndex(), Object.class);
            Preconditions.checkState((null == value || value instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            result.add((Comparable)value);
        }
        return result;
    }

    @Override
    public int compareTo(OrderByValue o) {
        int i = 0;
        for (OrderByItem each : this.orderByItems) {
            int result = CompareUtil.compareTo(this.orderValues.get(i), o.orderValues.get(i), each.getSegment().getOrderDirection(), each.getSegment().getNullOrderDirection(), this.orderValuesCaseSensitive.get(i));
            if (0 != result) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    @Generated
    public QueryResult getQueryResult() {
        return this.queryResult;
    }
}

