/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata.data;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.spi.data.collector.ShardingSphereDataCollector;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingStatisticsTableCollector
implements ShardingSphereDataCollector {
    private static final String SHARDING_TABLE_STATISTICS = "sharding_table_statistics";
    private static final String MYSQL_TABLE_ROWS_AND_DATA_LENGTH = "SELECT TABLE_ROWS, DATA_LENGTH FROM information_schema.TABLES WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s'";

    public Optional<ShardingSphereTableData> collect(ShardingSphereDatabase shardingSphereDatabase, ShardingSphereTable table) throws SQLException {
        Optional shardingRule = shardingSphereDatabase.getRuleMetaData().findSingleRule(ShardingRule.class);
        if (!shardingRule.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.collectForShardingStatisticTable(shardingSphereDatabase, (ShardingRule)shardingRule.get(), table));
    }

    private ShardingSphereTableData collectForShardingStatisticTable(ShardingSphereDatabase shardingSphereDatabase, ShardingRule shardingRule, ShardingSphereTable table) throws SQLException {
        ShardingSphereTableData result = new ShardingSphereTableData(SHARDING_TABLE_STATISTICS, new ArrayList(table.getColumns().values()));
        int count = 1;
        for (TableRule each : shardingRule.getTableRules().values()) {
            for (DataNode dataNode : each.getActualDataNodes()) {
                LinkedList<Object> row = new LinkedList<Object>();
                row.add(count++);
                row.add(shardingSphereDatabase.getName());
                row.add(each.getLogicTable());
                row.add(dataNode.getDataSourceName());
                row.add(dataNode.getTableName());
                this.addTableRowsAndDataLength(shardingSphereDatabase.getResourceMetaData().getDataSources(), dataNode, row, shardingSphereDatabase.getProtocolType());
                result.getRows().add(new ShardingSphereRowData(row));
            }
        }
        return result;
    }

    private void addTableRowsAndDataLength(Map<String, DataSource> dataSources, DataNode dataNode, List<Object> row, DatabaseType databaseType) throws SQLException {
        if (databaseType instanceof MySQLDatabaseType) {
            this.addForMySQL(dataSources, dataNode, row);
        } else if (databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType) {
            row.add(BigDecimal.ZERO);
            row.add(BigDecimal.ZERO);
        }
    }

    private void addForMySQL(Map<String, DataSource> dataSources, DataNode dataNode, List<Object> row) throws SQLException {
        DataSource dataSource = dataSources.get(dataNode.getDataSourceName());
        BigDecimal tableRows = BigDecimal.ZERO;
        BigDecimal dataLength = BigDecimal.ZERO;
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format(MYSQL_TABLE_ROWS_AND_DATA_LENGTH, connection.getCatalog(), dataNode.getTableName()));){
            if (resultSet.next()) {
                tableRows = resultSet.getBigDecimal("TABLE_ROWS");
                dataLength = resultSet.getBigDecimal("DATA_LENGTH");
            }
        }
        row.add(tableRows);
        row.add(dataLength);
    }

    public String getType() {
        return SHARDING_TABLE_STATISTICS;
    }
}

