/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.parameter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rewrite.parameter.impl.ShardingGeneratedKeyInsertValueParameterRewriter;
import org.apache.shardingsphere.sharding.rewrite.parameter.impl.ShardingPaginationParameterRewriter;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.aware.ShardingRuleAware;

public final class ShardingParameterRewriterBuilder
implements ParameterRewriterBuilder {
    private final ShardingRule shardingRule;
    private final RouteContext routeContext;
    private final Map<String, ShardingSphereSchema> schemas;
    private final SQLStatementContext<?> sqlStatementContext;

    public Collection<ParameterRewriter> getParameterRewriters() {
        LinkedList<ParameterRewriter> result = new LinkedList<ParameterRewriter>();
        this.addParameterRewriter(result, new ShardingGeneratedKeyInsertValueParameterRewriter());
        this.addParameterRewriter(result, new ShardingPaginationParameterRewriter());
        return result;
    }

    private void addParameterRewriter(Collection<ParameterRewriter> parameterRewriters, ParameterRewriter toBeAddedParameterRewriter) {
        if (toBeAddedParameterRewriter instanceof SchemaMetaDataAware) {
            ((SchemaMetaDataAware)toBeAddedParameterRewriter).setSchemas(this.schemas);
        }
        if (toBeAddedParameterRewriter instanceof ShardingRuleAware) {
            ((ShardingRuleAware)toBeAddedParameterRewriter).setShardingRule(this.shardingRule);
        }
        if (toBeAddedParameterRewriter instanceof RouteContextAware) {
            ((RouteContextAware)toBeAddedParameterRewriter).setRouteContext(this.routeContext);
        }
        if (toBeAddedParameterRewriter.isNeedRewrite(this.sqlStatementContext)) {
            parameterRewriters.add(toBeAddedParameterRewriter);
        }
    }

    @Generated
    public ShardingParameterRewriterBuilder(ShardingRule shardingRule, RouteContext routeContext, Map<String, ShardingSphereSchema> schemas, SQLStatementContext<?> sqlStatementContext) {
        this.shardingRule = shardingRule;
        this.routeContext = routeContext;
        this.schemas = schemas;
        this.sqlStatementContext = sqlStatementContext;
    }
}

