/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.binder.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.AggregationDistinctToken;

public final class AggregationDistinctTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext<?>>,
IgnoreForSingleRoute {
    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext;
    }

    public Collection<AggregationDistinctToken> generateSQLTokens(SQLStatementContext<?> sqlStatementContext) {
        LinkedList<AggregationDistinctToken> result = new LinkedList<AggregationDistinctToken>();
        for (AggregationDistinctProjection each : ((SelectStatementContext)sqlStatementContext).getProjectionsContext().getAggregationDistinctProjections()) {
            result.add(this.generateSQLToken(each));
        }
        return result;
    }

    private AggregationDistinctToken generateSQLToken(AggregationDistinctProjection projection) {
        Preconditions.checkArgument((boolean)projection.getAlias().isPresent());
        String derivedAlias = DerivedColumn.isDerivedColumnName((String)((String)projection.getAlias().get())) ? (String)projection.getAlias().get() : null;
        return new AggregationDistinctToken(projection.getStartIndex(), projection.getStopIndex(), projection.getDistinctInnerExpression(), derivedAlias);
    }
}

