/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingInsertValue;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingInsertValuesToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;

public final class ShardingInsertValuesTokenGenerator
implements OptionalSQLTokenGenerator<InsertStatementContext>,
RouteContextAware {
    private RouteContext routeContext;

    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && !((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getValues().isEmpty();
    }

    public InsertValuesToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Collection insertValuesSegments = ((InsertStatement)insertStatementContext.getSqlStatement()).getValues();
        ShardingInsertValuesToken result = new ShardingInsertValuesToken(this.getStartIndex(insertValuesSegments), this.getStopIndex(insertValuesSegments));
        Iterator originalDataNodesIterator = null == this.routeContext || this.routeContext.getOriginalDataNodes().isEmpty() ? null : this.routeContext.getOriginalDataNodes().iterator();
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            List expressionSegments = each.getValueExpressions();
            List<DataNode> dataNodes = null == originalDataNodesIterator ? Collections.emptyList() : (Collection)originalDataNodesIterator.next();
            result.getInsertValues().add(new ShardingInsertValue(expressionSegments, dataNodes));
        }
        return result;
    }

    private int getStartIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStartIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.min(result, each.getStartIndex());
        }
        return result;
    }

    private int getStopIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStopIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.max(result, each.getStopIndex());
        }
        return result;
    }

    @Generated
    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
}

