/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.TableToken;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.aware.ShardingRuleAware;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;

public final class TableTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext<?>>,
ShardingRuleAware,
RouteContextAware {
    private ShardingRule shardingRule;
    private RouteContext routeContext;

    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return this.routeContext.containsTableSharding();
    }

    public Collection<TableToken> generateSQLTokens(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof TableAvailable ? this.generateSQLTokens((TableAvailable)sqlStatementContext) : Collections.emptyList();
    }

    private Collection<TableToken> generateSQLTokens(TableAvailable sqlStatementContext) {
        LinkedList<TableToken> result = new LinkedList<TableToken>();
        for (SimpleTableSegment each : sqlStatementContext.getAllTables()) {
            TableNameSegment tableName = each.getTableName();
            if (!this.shardingRule.findTableRule(tableName.getIdentifier().getValue()).isPresent()) continue;
            result.add(new TableToken(tableName.getStartIndex(), tableName.getStopIndex(), tableName.getIdentifier(), (SQLStatementContext)sqlStatementContext, this.shardingRule));
        }
        return result;
    }

    @Override
    @Generated
    public void setShardingRule(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }

    @Generated
    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
}

