/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import lombok.Generated;
import org.apache.shardingsphere.infra.context.ConnectionContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.sql.parser.sql.common.constant.DirectionType;

public final class FetchDirectionToken
extends SQLToken
implements Substitutable {
    private final int stopIndex;
    private final DirectionType directionType;
    private final long fetchCount;
    private final String cursorName;
    private final ConnectionContext connectionContext;

    public FetchDirectionToken(int startIndex, int stopIndex, DirectionType directionType, long fetchCount, String cursorName, ConnectionContext connectionContext) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.directionType = directionType;
        this.fetchCount = fetchCount;
        this.cursorName = cursorName;
        this.connectionContext = connectionContext;
    }

    public String toString() {
        long actualFetchCount = Math.max(this.fetchCount - this.connectionContext.getCursorConnectionContext().getMinGroupRowCounts().getOrDefault(this.cursorName, 0L), 0L);
        if (DirectionType.isForwardCountDirectionType((DirectionType)this.directionType)) {
            return " FORWARD " + actualFetchCount + " ";
        }
        if (DirectionType.isBackwardCountDirectionType((DirectionType)this.directionType)) {
            return " BACKWARD " + actualFetchCount + " ";
        }
        if (DirectionType.ABSOLUTE_COUNT.equals((Object)this.directionType)) {
            return " ABSOLUTE " + actualFetchCount + " ";
        }
        if (DirectionType.RELATIVE_COUNT.equals((Object)this.directionType)) {
            return " RELATIVE " + actualFetchCount + " ";
        }
        return this.directionType.getName();
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

