/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.impl.ConditionValueBetweenOperatorGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.impl.ConditionValueCompareOperatorGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.impl.ConditionValueInOperatorGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;

public final class ConditionValueGeneratorFactory {
    private static final ConditionValueCompareOperatorGenerator COMPARE_OPERATOR_GENERATOR = new ConditionValueCompareOperatorGenerator();
    private static final ConditionValueInOperatorGenerator IN_OPERATOR_GENERATOR = new ConditionValueInOperatorGenerator();
    private static final ConditionValueBetweenOperatorGenerator BETWEEN_OPERATOR_GENERATOR = new ConditionValueBetweenOperatorGenerator();

    public static Optional<ShardingConditionValue> generate(ExpressionSegment predicate, Column column, List<Object> parameters) {
        if (predicate instanceof BinaryOperationExpression) {
            return COMPARE_OPERATOR_GENERATOR.generate((BinaryOperationExpression)predicate, column, parameters);
        }
        if (predicate instanceof InExpression) {
            return IN_OPERATOR_GENERATOR.generate((InExpression)predicate, column, parameters);
        }
        if (predicate instanceof BetweenExpression) {
            return BETWEEN_OPERATOR_GENERATOR.generate((BetweenExpression)predicate, column, parameters);
        }
        return Optional.empty();
    }

    @Generated
    private ConditionValueGeneratorFactory() {
    }
}

