/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator.impl;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.datetime.DatetimeServiceFactory;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.util.SafeNumberOperationUtil;

public final class ConditionValueBetweenOperatorGenerator
implements ConditionValueGenerator<BetweenExpression> {
    @Override
    public Optional<ShardingConditionValue> generate(BetweenExpression predicate, Column column, List<Object> parameters) {
        ConditionValue betweenConditionValue = new ConditionValue(predicate.getBetweenExpr(), parameters);
        ConditionValue andConditionValue = new ConditionValue(predicate.getAndExpr(), parameters);
        Optional<Comparable<?>> betweenValue = betweenConditionValue.getValue();
        Optional<Comparable<?>> andValue = andConditionValue.getValue();
        ArrayList<Integer> parameterMarkerIndexes = new ArrayList<Integer>(2);
        betweenConditionValue.getParameterMarkerIndex().ifPresent(parameterMarkerIndexes::add);
        andConditionValue.getParameterMarkerIndex().ifPresent(parameterMarkerIndexes::add);
        if (betweenValue.isPresent() && andValue.isPresent()) {
            return Optional.of(new RangeShardingConditionValue(column.getName(), column.getTableName(), SafeNumberOperationUtil.safeClosed(betweenValue.get(), andValue.get()), parameterMarkerIndexes));
        }
        Date datetime = DatetimeServiceFactory.getInstance().getDatetime();
        if (!betweenValue.isPresent() && ExpressionConditionUtils.isNowExpression(predicate.getBetweenExpr())) {
            betweenValue = Optional.of(datetime);
        }
        if (!andValue.isPresent() && ExpressionConditionUtils.isNowExpression(predicate.getAndExpr())) {
            andValue = Optional.of(datetime);
        }
        if (!betweenValue.isPresent() || !andValue.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new RangeShardingConditionValue(column.getName(), column.getTableName(), Range.closed(betweenValue.get(), andValue.get()), parameterMarkerIndexes));
    }
}

