/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator.impl;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.datetime.DatetimeServiceFactory;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;

public final class ConditionValueCompareOperatorGenerator
implements ConditionValueGenerator<BinaryOperationExpression> {
    private static final String EQUAL = "=";
    private static final String GREATER_THAN = ">";
    private static final String LESS_THAN = "<";
    private static final String AT_MOST = "<=";
    private static final String AT_LEAST = ">=";
    private static final Collection<String> OPERATORS = new HashSet<String>(Arrays.asList("=", ">", "<", ">=", "<="));

    @Override
    public Optional<ShardingConditionValue> generate(BinaryOperationExpression predicate, Column column, List<Object> parameters) {
        String operator = predicate.getOperator();
        if (!this.isSupportedOperator(operator)) {
            return Optional.empty();
        }
        ExpressionSegment valueExpression = predicate.getLeft() instanceof ColumnSegment ? predicate.getRight() : predicate.getLeft();
        ConditionValue conditionValue = new ConditionValue(valueExpression, parameters);
        Optional<Comparable<?>> value = conditionValue.getValue();
        if (value.isPresent()) {
            return this.generate(value.get(), column, operator, conditionValue.getParameterMarkerIndex().orElse(-1));
        }
        if (ExpressionConditionUtils.isNowExpression(valueExpression)) {
            return this.generate(DatetimeServiceFactory.getInstance().getDatetime(), column, operator, -1);
        }
        return Optional.empty();
    }

    private Optional<ShardingConditionValue> generate(Comparable<?> comparable, Column column, String operator, int parameterMarkerIndex) {
        String columnName = column.getName();
        String tableName = column.getTableName();
        List<Integer> parameterMarkerIndexes = parameterMarkerIndex > -1 ? Collections.singletonList(parameterMarkerIndex) : Collections.emptyList();
        switch (operator) {
            case "=": {
                return Optional.of(new ListShardingConditionValue(columnName, tableName, new ArrayList(Collections.singleton(comparable)), parameterMarkerIndexes));
            }
            case ">": {
                return Optional.of(new RangeShardingConditionValue(columnName, tableName, Range.greaterThan(comparable), parameterMarkerIndexes));
            }
            case "<": {
                return Optional.of(new RangeShardingConditionValue(columnName, tableName, Range.lessThan(comparable), parameterMarkerIndexes));
            }
            case "<=": {
                return Optional.of(new RangeShardingConditionValue(columnName, tableName, Range.atMost(comparable), parameterMarkerIndexes));
            }
            case ">=": {
                return Optional.of(new RangeShardingConditionValue(columnName, tableName, Range.atLeast(comparable), parameterMarkerIndexes));
            }
        }
        return Optional.empty();
    }

    private boolean isSupportedOperator(String operator) {
        return OPERATORS.contains(operator);
    }
}

