/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.datetime.DatetimeService;
import org.apache.shardingsphere.infra.datetime.DatetimeServiceFactory;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;

public final class ConditionValueInOperatorGenerator
implements ConditionValueGenerator<InExpression> {
    @Override
    public Optional<ShardingConditionValue> generate(InExpression predicate, Column column, List<Object> parameters) {
        LinkedList shardingConditionValues = new LinkedList();
        ArrayList<Integer> parameterMarkerIndexes = new ArrayList<Integer>(predicate.getExpressionList().size());
        DatetimeService datetimeService = DatetimeServiceFactory.getInstance();
        for (ExpressionSegment each : predicate.getExpressionList()) {
            ConditionValue conditionValue = new ConditionValue(each, parameters);
            Optional<Comparable<?>> value = conditionValue.getValue();
            if (value.isPresent()) {
                shardingConditionValues.add(value.get());
                conditionValue.getParameterMarkerIndex().ifPresent(parameterMarkerIndexes::add);
                continue;
            }
            if (!ExpressionConditionUtils.isNowExpression(each)) continue;
            shardingConditionValues.add(datetimeService.getDatetime());
        }
        return shardingConditionValues.isEmpty() ? Optional.empty() : Optional.of(new ListShardingConditionValue(column.getName(), column.getTableName(), shardingConditionValues, parameterMarkerIndexes));
    }
}

