/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.broadcast;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingDataSourceGroupBroadcastRoutingEngine
implements ShardingRouteEngine {
    @Override
    public RouteContext route(ShardingRule shardingRule) {
        RouteContext result = new RouteContext();
        Collection<Set<String>> broadcastDataSourceGroup = this.getBroadcastDataSourceGroup(this.getDataSourceGroup(shardingRule));
        for (Set<String> each : broadcastDataSourceGroup) {
            String dataSourceName = this.getRandomDataSourceName(each);
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName, dataSourceName), Collections.emptyList()));
        }
        return result;
    }

    private Collection<Set<String>> getBroadcastDataSourceGroup(Collection<Set<String>> dataSourceGroup) {
        Collection<Set<String>> result = new LinkedList<Set<String>>();
        for (Set<String> each : dataSourceGroup) {
            result = this.getCandidateDataSourceGroup(result, each);
        }
        return result;
    }

    private Collection<Set<String>> getDataSourceGroup(ShardingRule shardingRule) {
        LinkedList<Set<String>> result = new LinkedList<Set<String>>();
        for (TableRule each : shardingRule.getTableRules().values()) {
            result.add(each.getDataNodeGroups().keySet());
        }
        return result;
    }

    private Collection<Set<String>> getCandidateDataSourceGroup(Collection<Set<String>> dataSourceSetGroup, Set<String> compareSet) {
        LinkedList<Set<String>> result = new LinkedList<Set<String>>();
        if (dataSourceSetGroup.isEmpty()) {
            result.add(compareSet);
            return result;
        }
        boolean hasIntersection = false;
        for (Set<String> each : dataSourceSetGroup) {
            Sets.SetView intersections = Sets.intersection(each, compareSet);
            if (!intersections.isEmpty()) {
                result.add((Set<String>)intersections);
                hasIntersection = true;
                continue;
            }
            result.add(each);
        }
        if (!hasIntersection) {
            result.add(compareSet);
        }
        return result;
    }

    private String getRandomDataSourceName(Collection<String> dataSourceNames) {
        return new ArrayList<String>(dataSourceNames).get(ThreadLocalRandom.current().nextInt(dataSourceNames.size()));
    }
}

