/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.connection.ShardingDDLRouteException;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedShardingOperationException;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;

public final class ShardingAlterTableStatementValidator
extends ShardingDDLStatementValidator<AlterTableStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<AlterTableStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props) {
        Collection tableNames = sqlStatementContext instanceof TableAvailable ? (Collection)((TableAvailable)sqlStatementContext).getAllTables().stream().map(each -> each.getTableName().getIdentifier().getValue()).collect(Collectors.toList()) : sqlStatementContext.getTablesContext().getTableNames();
        Optional renameTable = ((AlterTableStatement)sqlStatementContext.getSqlStatement()).getRenameTable();
        if (renameTable.isPresent() && this.containsShardingBroadcastTable(shardingRule, tableNames)) {
            throw new UnsupportedShardingOperationException("ALTER TABLE ... RENAME TO ...", ((SimpleTableSegment)renameTable.get()).getTableName().getIdentifier().getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsShardingBroadcastTable(ShardingRule shardingRule, Collection<String> tableNames) {
        if (shardingRule.tableRuleExists(tableNames)) return true;
        if (!tableNames.stream().anyMatch(shardingRule::isBroadcastTable)) return false;
        return true;
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<AlterTableStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        String primaryTable = ((AlterTableStatement)sqlStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        if (this.isRouteUnitDataNodeDifferentSize(shardingRule, routeContext, primaryTable)) {
            throw new ShardingDDLRouteException("ALTER", "TABLE", sqlStatementContext.getTablesContext().getTableNames());
        }
    }
}

