/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.syntax.RenamedViewWithoutSameConfigurationException;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterViewStatementHandler;

public final class ShardingAlterViewStatementValidator
extends ShardingDDLStatementValidator<AlterViewStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<AlterViewStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props) {
        Optional renamedView;
        Optional selectStatement = AlterViewStatementHandler.getSelectStatement((AlterViewStatement)((AlterViewStatement)sqlStatementContext.getSqlStatement()));
        if (selectStatement.isPresent()) {
            TableExtractor extractor = new TableExtractor();
            extractor.extractTablesFromSelect((SelectStatement)selectStatement.get());
            this.validateShardingTable(shardingRule, "ALTER VIEW", extractor.getRewriteTables());
        }
        if ((renamedView = AlterViewStatementHandler.getRenameView((AlterViewStatement)((AlterViewStatement)sqlStatementContext.getSqlStatement()))).isPresent()) {
            String targetView = ((SimpleTableSegment)renamedView.get()).getTableName().getIdentifier().getValue();
            String originView = ((AlterViewStatement)sqlStatementContext.getSqlStatement()).getView().getTableName().getIdentifier().getValue();
            this.validateBroadcastShardingView(shardingRule, originView, targetView);
        }
    }

    private void validateBroadcastShardingView(ShardingRule shardingRule, String originView, String targetView) {
        if (shardingRule.isBroadcastTable(originView) ^ shardingRule.isBroadcastTable(targetView)) {
            throw new RenamedViewWithoutSameConfigurationException(originView, targetView);
        }
        if ((shardingRule.isShardingTable(originView) || shardingRule.isShardingTable(targetView)) && !shardingRule.isAllBindingTables(Arrays.asList(originView, targetView))) {
            throw new RenamedViewWithoutSameConfigurationException(originView, targetView);
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<AlterViewStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
    }
}

