/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.CreateFunctionStatementHandler;

public final class ShardingCreateFunctionStatementValidator
extends ShardingDDLStatementValidator<CreateFunctionStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<CreateFunctionStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props) {
        Optional routineBodySegment = CreateFunctionStatementHandler.getRoutineBodySegment((CreateFunctionStatement)((CreateFunctionStatement)sqlStatementContext.getSqlStatement()));
        if (!routineBodySegment.isPresent()) {
            return;
        }
        TableExtractor extractor = new TableExtractor();
        Collection existTables = extractor.extractExistTableFromRoutineBody((RoutineBodySegment)routineBodySegment.get());
        this.validateShardingTable(shardingRule, "CREATE FUNCTION", existTables);
        String defaultSchemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)database.getName());
        ShardingSphereSchema schema = ((CreateFunctionStatement)sqlStatementContext.getSqlStatement()).getFunctionName().flatMap(optional -> optional.getOwner().map(owner -> database.getSchema(owner.getIdentifier().getValue()))).orElseGet(() -> database.getSchema(defaultSchemaName));
        this.validateTableExist(schema, existTables);
        this.validateTableNotExist(schema, extractor.extractNotExistTableFromRoutineBody((RoutineBodySegment)routineBodySegment.get()));
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext<CreateFunctionStatement> sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
    }
}

