/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.dml;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.exception.syntax.DMLWithMultipleShardingTablesException;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public abstract class ShardingDMLStatementValidator<T extends SQLStatement>
implements ShardingStatementValidator<T> {
    protected void validateMultipleTable(ShardingRule shardingRule, SQLStatementContext<T> sqlStatementContext) {
        boolean isAllSingleTables;
        Collection tableNames = sqlStatementContext.getTablesContext().getTableNames();
        boolean isAllShardingTables = shardingRule.isAllShardingTables(tableNames) && (1 == tableNames.size() || shardingRule.isAllBindingTables(tableNames));
        boolean isAllBroadcastTables = shardingRule.isAllBroadcastTables(tableNames);
        boolean bl = isAllSingleTables = !shardingRule.tableRuleExists(tableNames);
        if (!(isAllShardingTables || isAllBroadcastTables || isAllSingleTables)) {
            throw new DMLWithMultipleShardingTablesException(tableNames);
        }
    }

    protected boolean isSameRouteContext(RouteContext routeContext, RouteContext subRouteContext) {
        if (routeContext.getRouteUnits().size() != subRouteContext.getRouteUnits().size()) {
            return false;
        }
        Iterator routeContextIterator = routeContext.getRouteUnits().iterator();
        Iterator setAssignmentRouteContextIterator = subRouteContext.getRouteUnits().iterator();
        while (routeContextIterator.hasNext()) {
            RouteUnit routeUnit = (RouteUnit)routeContextIterator.next();
            RouteUnit setAssignmentRouteUnit = (RouteUnit)setAssignmentRouteContextIterator.next();
            if (!routeUnit.getDataSourceMapper().getLogicName().equals(setAssignmentRouteUnit.getDataSourceMapper().getLogicName()) || !routeUnit.getDataSourceMapper().getActualName().equals(setAssignmentRouteUnit.getDataSourceMapper().getActualName())) {
                return false;
            }
            if (this.isSameTableMapper(routeUnit.getTableMappers(), setAssignmentRouteUnit.getTableMappers())) continue;
            return false;
        }
        return true;
    }

    private boolean isSameTableMapper(Collection<RouteMapper> tableMappers, Collection<RouteMapper> setAssignmentTableMappers) {
        if (tableMappers.size() != setAssignmentTableMappers.size()) {
            return false;
        }
        Iterator<RouteMapper> tableMapperIterator = tableMappers.iterator();
        Iterator<RouteMapper> setAssignmentTableMapperIterator = setAssignmentTableMappers.iterator();
        while (tableMapperIterator.hasNext()) {
            RouteMapper routeMapper = tableMapperIterator.next();
            RouteMapper setAssignmentRouteMapper = setAssignmentTableMapperIterator.next();
            if (routeMapper.getLogicName().equals(setAssignmentRouteMapper.getLogicName()) && routeMapper.getActualName().equals(setAssignmentRouteMapper.getActualName())) continue;
            return false;
        }
        return true;
    }

    protected Optional<ShardingConditions> createShardingConditions(SQLStatementContext<?> sqlStatementContext, ShardingRule shardingRule, Collection<AssignmentSegment> assignments, List<Object> parameters) {
        LinkedList values = new LinkedList();
        String tableName = (String)sqlStatementContext.getTablesContext().getTableNames().iterator().next();
        for (AssignmentSegment each : assignments) {
            String shardingColumn = ((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue();
            if (!shardingRule.findShardingColumn(shardingColumn, tableName).isPresent()) continue;
            Optional<Object> assignmentValue = this.getShardingColumnAssignmentValue(each, parameters);
            assignmentValue.ifPresent(optional -> values.add(new ListShardingConditionValue<Object>(shardingColumn, tableName, Collections.singletonList(optional))));
        }
        if (values.isEmpty()) {
            return Optional.empty();
        }
        ShardingCondition shardingCondition = new ShardingCondition();
        shardingCondition.getValues().addAll(values);
        return Optional.of(new ShardingConditions(Collections.singletonList(shardingCondition), sqlStatementContext, shardingRule));
    }

    private Optional<Object> getShardingColumnAssignmentValue(AssignmentSegment assignmentSegment, List<Object> parameters) {
        ExpressionSegment segment = assignmentSegment.getValue();
        int shardingSetAssignIndex = -1;
        if (segment instanceof ParameterMarkerExpressionSegment) {
            shardingSetAssignIndex = ((ParameterMarkerExpressionSegment)segment).getParameterMarkerIndex();
        }
        if (segment instanceof LiteralExpressionSegment) {
            return Optional.of(((LiteralExpressionSegment)segment).getLiterals());
        }
        if (-1 == shardingSetAssignIndex || shardingSetAssignIndex > parameters.size() - 1) {
            return Optional.empty();
        }
        return Optional.of(parameters.get(shardingSetAssignIndex));
    }
}

