/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sharding.exception.metadata.ActualTableNotFoundException;
import org.apache.shardingsphere.sharding.exception.metadata.BindingTableNotFoundException;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class BindingTableRule {
    private final Map<String, TableRule> tableRules = new LinkedHashMap<String, TableRule>();

    public boolean hasLogicTable(String logicTable) {
        return this.tableRules.containsKey(logicTable.toLowerCase());
    }

    public String getBindingActualTable(String dataSource, String logicTable, String otherLogicTable, String otherActualTable) {
        Optional<TableRule> otherLogicTableRule = Optional.ofNullable(this.tableRules.get(otherLogicTable.toLowerCase()));
        int index = otherLogicTableRule.map(optional -> optional.findActualTableIndex(dataSource, otherActualTable)).orElse(-1);
        if (-1 == index) {
            throw new ActualTableNotFoundException(dataSource, otherActualTable);
        }
        Optional<TableRule> tableRule = Optional.ofNullable(this.tableRules.get(logicTable.toLowerCase()));
        if (tableRule.isPresent()) {
            return tableRule.get().getActualDataNodes().get(index).getTableName();
        }
        throw new BindingTableNotFoundException(dataSource, logicTable, otherActualTable);
    }

    public Collection<String> getAllLogicTables() {
        return this.tableRules.keySet();
    }

    Map<String, String> getLogicAndActualTables(String dataSource, String logicTable, String actualTable, Collection<String> availableLogicBindingTables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String each : availableLogicBindingTables) {
            String availableLogicTable = each.toLowerCase();
            if (availableLogicTable.equalsIgnoreCase(logicTable) || !this.hasLogicTable(availableLogicTable)) continue;
            result.put(availableLogicTable, this.getBindingActualTable(dataSource, availableLogicTable, logicTable, actualTable));
        }
        return result;
    }

    @Generated
    public BindingTableRule() {
    }

    @Generated
    public Map<String, TableRule> getTableRules() {
        return this.tableRules;
    }
}

