/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler.converter;

import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.scaling.distsql.statement.segment.InputOrOutputSegment;
import org.apache.shardingsphere.scaling.distsql.statement.segment.ShardingScalingRuleConfigurationSegment;

public final class ShardingScalingRuleStatementConverter {
    public static OnRuleAlteredActionConfiguration convert(ShardingScalingRuleConfigurationSegment segment) {
        OnRuleAlteredActionConfiguration.InputConfiguration inputConfig = ShardingScalingRuleStatementConverter.convertToInputConfiguration(segment.getInputSegment());
        OnRuleAlteredActionConfiguration.OutputConfiguration outputConfig = ShardingScalingRuleStatementConverter.convertToOutputConfiguration(segment.getOutputSegment());
        ShardingSphereAlgorithmConfiguration streamChannel = ShardingScalingRuleStatementConverter.convertToAlgorithm(segment.getStreamChannel());
        ShardingSphereAlgorithmConfiguration completionDetector = ShardingScalingRuleStatementConverter.convertToAlgorithm(segment.getCompletionDetector());
        ShardingSphereAlgorithmConfiguration dataConsistencyChecker = ShardingScalingRuleStatementConverter.convertToAlgorithm(segment.getDataConsistencyCalculator());
        return new OnRuleAlteredActionConfiguration(inputConfig, outputConfig, streamChannel, completionDetector, dataConsistencyChecker);
    }

    private static OnRuleAlteredActionConfiguration.InputConfiguration convertToInputConfiguration(InputOrOutputSegment inputSegment) {
        if (null == inputSegment) {
            return null;
        }
        return new OnRuleAlteredActionConfiguration.InputConfiguration(inputSegment.getWorkerThread(), inputSegment.getBatchSize(), inputSegment.getShardingSize(), ShardingScalingRuleStatementConverter.convertToAlgorithm(inputSegment.getRateLimiter()));
    }

    private static OnRuleAlteredActionConfiguration.OutputConfiguration convertToOutputConfiguration(InputOrOutputSegment outputSegment) {
        if (null == outputSegment) {
            return null;
        }
        return new OnRuleAlteredActionConfiguration.OutputConfiguration(outputSegment.getWorkerThread(), outputSegment.getBatchSize(), ShardingScalingRuleStatementConverter.convertToAlgorithm(outputSegment.getRateLimiter()));
    }

    private static ShardingSphereAlgorithmConfiguration convertToAlgorithm(AlgorithmSegment segment) {
        if (null == segment) {
            return null;
        }
        return new ShardingSphereAlgorithmConfiguration(segment.getName(), segment.getProps());
    }

    @Generated
    private ShardingScalingRuleStatementConverter() {
    }
}

