/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler.query;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.scaling.distsql.statement.ShowShardingScalingRulesStatement;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingScalingRulesQueryResultSet
implements DistSQLResultSet {
    private Iterator<Map.Entry<String, OnRuleAlteredActionConfiguration>> data;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        Optional<ShardingRuleConfiguration> ruleConfig = database.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof ShardingRuleConfiguration).map(each -> (ShardingRuleConfiguration)each).findAny();
        this.data = ruleConfig.map(ShardingRuleConfiguration::getScaling).orElse(Collections.emptyMap()).entrySet().iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "input", "output", "stream_channel", "completion_detector", "data_consistency_checker");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.buildRowData(this.data.next());
    }

    private Collection<Object> buildRowData(Map.Entry<String, OnRuleAlteredActionConfiguration> data) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(data.getKey());
        OnRuleAlteredActionConfiguration shardingScalingRule = data.getValue();
        result.add(null == shardingScalingRule ? "" : this.getString(shardingScalingRule.getInput()));
        result.add(null == shardingScalingRule ? "" : this.getString(shardingScalingRule.getOutput()));
        result.add(null == shardingScalingRule ? "" : this.getString(shardingScalingRule.getStreamChannel()));
        result.add(null == shardingScalingRule ? "" : this.getString(shardingScalingRule.getCompletionDetector()));
        result.add(null == shardingScalingRule ? "" : this.getString(shardingScalingRule.getDataConsistencyCalculator()));
        return result;
    }

    private String getString(Object obj) {
        return null == obj ? "" : new Gson().toJson(obj);
    }

    public String getType() {
        return ShowShardingScalingRulesStatement.class.getName();
    }
}

