/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.preprocess;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.distsql.preprocess.RuleDefinitionAlterPreprocessor;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingTableRuleStatement;

public final class AlterShardingTableRuleStatementPreprocessor
implements RuleDefinitionAlterPreprocessor<ShardingRuleConfiguration> {
    public ShardingRuleConfiguration preprocess(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        result.setShardingAlgorithms(new HashMap(currentRuleConfig.getShardingAlgorithms()));
        result.setAutoTables(new LinkedList(currentRuleConfig.getAutoTables()));
        result.setDefaultShardingColumn(currentRuleConfig.getDefaultShardingColumn());
        result.setDefaultTableShardingStrategy(currentRuleConfig.getDefaultTableShardingStrategy());
        result.setBindingTableGroups(new LinkedList(currentRuleConfig.getBindingTableGroups()));
        result.setDefaultDatabaseShardingStrategy(currentRuleConfig.getDefaultDatabaseShardingStrategy());
        result.setTables(new LinkedList(currentRuleConfig.getTables()));
        result.setBroadcastTables(new LinkedList(currentRuleConfig.getBroadcastTables()));
        result.setDefaultKeyGenerateStrategy(this.getKeyGenerateStrategyConfiguration(currentRuleConfig));
        result.setKeyGenerators(new HashMap(currentRuleConfig.getKeyGenerators()));
        result.setScalingName(currentRuleConfig.getScalingName());
        result.setScaling(new LinkedHashMap(currentRuleConfig.getScaling()));
        return result;
    }

    private KeyGenerateStrategyConfiguration getKeyGenerateStrategyConfiguration(ShardingRuleConfiguration currentRuleConfig) {
        if (null == currentRuleConfig.getDefaultKeyGenerateStrategy()) {
            return null;
        }
        return new KeyGenerateStrategyConfiguration(currentRuleConfig.getDefaultKeyGenerateStrategy().getColumn(), currentRuleConfig.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
    }

    public String getType() {
        return AlterShardingTableRuleStatement.class.getName();
    }
}

