/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal.show;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public class LogicTablesMergedResult
extends MemoryMergedResult<ShardingRule> {
    public LogicTablesMergedResult(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, PhysicalSchemaMetaData schemaMetaData, List<QueryResult> queryResults) throws SQLException {
        super((ShardingSphereRule)shardingRule, schemaMetaData, sqlStatementContext, queryResults);
    }

    protected final List<MemoryQueryResultRow> init(ShardingRule shardingRule, PhysicalSchemaMetaData schemaMetaData, SQLStatementContext sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        LinkedList<MemoryQueryResultRow> result = new LinkedList<MemoryQueryResultRow>();
        HashSet<String> tableNames = new HashSet<String>();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                MemoryQueryResultRow memoryResultSetRow = new MemoryQueryResultRow(each);
                String actualTableName = memoryResultSetRow.getCell(1).toString();
                Optional tableRule = shardingRule.findTableRuleByActualTable(actualTableName);
                if (!tableRule.isPresent()) {
                    if (!shardingRule.getTableRules().isEmpty() && !tableNames.add(actualTableName)) continue;
                    result.add(memoryResultSetRow);
                    continue;
                }
                if (!tableNames.add(((TableRule)tableRule.get()).getLogicTable())) continue;
                memoryResultSetRow.setCell(1, (Object)((TableRule)tableRule.get()).getLogicTable());
                this.setCellValue(memoryResultSetRow, ((TableRule)tableRule.get()).getLogicTable(), actualTableName);
                result.add(memoryResultSetRow);
            }
        }
        return result;
    }

    protected void setCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName) {
    }
}

