/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.row;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.wrapper.SQLWrapperException;

public final class SQLFederationRowEnumerator
implements Enumerator<Object[]> {
    private final Collection<Object[]> rows;
    private final Collection<Statement> statements;
    private Iterator<Object[]> iterator;
    private Object[] currentRow;

    public SQLFederationRowEnumerator(Collection<Object[]> rows, Collection<Statement> statements) {
        this.rows = rows;
        this.statements = statements;
        this.iterator = rows.iterator();
    }

    public Object[] current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        if (this.iterator.hasNext()) {
            this.currentRow = this.iterator.next();
            return true;
        }
        this.currentRow = null;
        this.iterator = this.rows.iterator();
        return false;
    }

    public void reset() {
    }

    public void close() {
        try {
            for (Statement each : this.statements) {
                each.close();
            }
            this.currentRow = null;
            this.iterator = this.rows.iterator();
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }
}

