/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.original;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sqlfederation.executor.FilterableTableScanExecutor;
import org.apache.shardingsphere.sqlfederation.executor.TableScanExecutorContext;
import org.apache.shardingsphere.sqlfederation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.sqlfederation.optimizer.context.OptimizerContextFactory;
import org.apache.shardingsphere.sqlfederation.optimizer.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.sqlfederation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.filter.FilterableDatabase;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationExecutor;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationExecutorContext;

public final class OriginalSQLFederationExecutor
implements SQLFederationExecutor {
    public static final String CONNECTION_URL = "jdbc:calcite:";
    public static final String DRIVER_NAME = "org.apache.calcite.jdbc.Driver";
    private static final JavaTypeFactory JAVA_TYPE_FACTORY = new JavaTypeFactoryImpl();
    private String databaseName;
    private String schemaName;
    private OptimizerContext optimizerContext;
    private ShardingSphereRuleMetaData globalRuleMetaData;
    private ConfigurationProperties props;
    private ShardingSphereData shardingSphereData;
    private JDBCExecutor jdbcExecutor;
    private EventBusContext eventBusContext;
    private Connection connection;
    private Statement statement;

    public void init(String databaseName, String schemaName, ShardingSphereMetaData metaData, ShardingSphereData shardingSphereData, JDBCExecutor jdbcExecutor, EventBusContext eventBusContext) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.optimizerContext = OptimizerContextFactory.create((Map)metaData.getDatabases(), (ShardingSphereRuleMetaData)metaData.getGlobalRuleMetaData());
        this.globalRuleMetaData = metaData.getGlobalRuleMetaData();
        this.shardingSphereData = shardingSphereData;
        this.props = metaData.getProps();
        this.jdbcExecutor = jdbcExecutor;
        this.eventBusContext = eventBusContext;
    }

    public ResultSet executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationExecutorContext federationContext) throws SQLException {
        this.connection = this.createConnection(prepareEngine, callback, federationContext);
        PreparedStatement preparedStatement = this.connection.prepareStatement(SQLUtil.trimSemicolon((String)federationContext.getQueryContext().getSql()));
        this.setParameters(preparedStatement, federationContext.getQueryContext().getParameters());
        this.statement = preparedStatement;
        return preparedStatement.executeQuery();
    }

    private Connection createConnection(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationExecutorContext federationContext) throws SQLException {
        Connection result = DriverManager.getConnection(CONNECTION_URL, ((OptimizerParserContext)this.optimizerContext.getParserContexts().get(this.databaseName)).getDialectProps());
        this.addSchema(result.unwrap(CalciteConnection.class), prepareEngine, callback, federationContext);
        return result;
    }

    private void addSchema(CalciteConnection connection, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationExecutorContext federationContext) throws SQLException {
        TableScanExecutorContext executorContext = new TableScanExecutorContext(this.databaseName, this.schemaName, this.props, federationContext);
        FilterableTableScanExecutor executor = new FilterableTableScanExecutor(prepareEngine, this.jdbcExecutor, callback, this.optimizerContext, this.globalRuleMetaData, executorContext, this.shardingSphereData, this.eventBusContext);
        FilterableDatabase database = new FilterableDatabase((ShardingSphereDatabase)federationContext.getDatabases().get(this.databaseName.toLowerCase()), JAVA_TYPE_FACTORY, (TableScanExecutor)executor);
        connection.getRootSchema().add(this.schemaName, database.getSubSchema(this.schemaName));
        connection.setSchema(this.schemaName);
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> parameters) throws SQLException {
        int count = 1;
        for (Object each : parameters) {
            preparedStatement.setObject(count, each);
            ++count;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    public void close() throws SQLException {
        if (null != this.statement && !this.statement.isClosed()) {
            this.statement.close();
            this.connection.close();
        }
    }

    public String getType() {
        return "ORIGINAL";
    }

    @Generated
    public OriginalSQLFederationExecutor() {
    }

    static {
        try {
            Class.forName(DRIVER_NAME);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}

