/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqltranslator.jooq;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.sqltranslator.exception.SQLTranslationException;
import org.apache.shardingsphere.sqltranslator.exception.UnsupportedTranslatedDatabaseException;
import org.jooq.SQLDialect;

public final class JooQDialectRegistry {
    private static final Map<DatabaseType, SQLDialect> DATABASE_DIALECT_MAP = new HashMap<DatabaseType, SQLDialect>();

    public static SQLDialect getSQLDialect(DatabaseType databaseType) throws SQLTranslationException {
        SQLDialect result = DATABASE_DIALECT_MAP.get(databaseType);
        if (null == result) {
            throw new UnsupportedTranslatedDatabaseException(databaseType);
        }
        return result;
    }

    @Generated
    private JooQDialectRegistry() {
    }

    static {
        DATABASE_DIALECT_MAP.put(DatabaseTypeFactory.getInstance((String)"PostgreSQL"), SQLDialect.POSTGRES);
        DATABASE_DIALECT_MAP.put(DatabaseTypeFactory.getInstance((String)"MySQL"), SQLDialect.MYSQL);
        DATABASE_DIALECT_MAP.put(DatabaseTypeFactory.getInstance((String)"MariaDB"), SQLDialect.MARIADB);
        DATABASE_DIALECT_MAP.put(DatabaseTypeFactory.getInstance((String)"openGauss"), SQLDialect.POSTGRES);
        DATABASE_DIALECT_MAP.put(DatabaseTypeFactory.getInstance((String)"H2"), SQLDialect.H2);
        DATABASE_DIALECT_MAP.put(DatabaseTypeFactory.getInstance((String)"SQL92"), SQLDialect.DEFAULT);
    }
}

