/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.algorithm.loadbalance;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.traffic.spi.TrafficLoadBalanceAlgorithm;

public final class RoundRobinTrafficLoadBalanceAlgorithm
implements TrafficLoadBalanceAlgorithm {
    private final AtomicInteger count = new AtomicInteger(0);
    private Properties props;

    public void init(Properties props) {
        this.props = props;
    }

    public InstanceMetaData getInstanceId(String name, List<InstanceMetaData> instances) {
        return instances.get(Math.abs(this.count.getAndIncrement()) % instances.size());
    }

    public String getType() {
        return "ROUND_ROBIN";
    }

    public boolean isDefault() {
        return true;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

