/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.engine;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.traffic.rule.TrafficRule;
import org.apache.shardingsphere.traffic.rule.TrafficStrategyRule;
import org.apache.shardingsphere.traffic.spi.TrafficLoadBalanceAlgorithm;

public final class TrafficEngine {
    private final TrafficRule trafficRule;
    private final InstanceContext instanceContext;

    public Optional<String> dispatch(QueryContext queryContext, boolean inTransaction) {
        Optional<TrafficStrategyRule> strategyRule = this.trafficRule.findMatchedStrategyRule(queryContext, inTransaction);
        if (!strategyRule.isPresent() || this.isInvalidStrategyRule(strategyRule.get())) {
            return Optional.empty();
        }
        List instances = this.instanceContext.getAllClusterInstances(InstanceType.PROXY, strategyRule.get().getLabels());
        if (!instances.isEmpty()) {
            TrafficLoadBalanceAlgorithm loadBalancer = strategyRule.get().getLoadBalancer();
            InstanceMetaData instanceMetaData = 1 == instances.size() ? (InstanceMetaData)instances.iterator().next() : loadBalancer.getInstanceId(strategyRule.get().getName(), instances);
            return Optional.of(instanceMetaData.getId());
        }
        return Optional.empty();
    }

    private boolean isInvalidStrategyRule(TrafficStrategyRule strategyRule) {
        return strategyRule.getLabels().isEmpty() || null == strategyRule.getLoadBalancer();
    }

    @Generated
    public TrafficEngine(TrafficRule trafficRule, InstanceContext instanceContext) {
        this.trafficRule = trafficRule;
        this.instanceContext = instanceContext;
    }
}

