/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public final class ConnectionSavepointManager {
    private static final ConnectionSavepointManager INSTANCE = new ConnectionSavepointManager();
    private static final Map<Connection, Map<String, Savepoint>> CONNECTION_SAVEPOINT_MAP = new ConcurrentHashMap<Connection, Map<String, Savepoint>>(128);

    public static ConnectionSavepointManager getInstance() {
        return INSTANCE;
    }

    public void setSavepoint(Connection connection, String savepointName) throws SQLException {
        Savepoint result = connection.setSavepoint(savepointName);
        CONNECTION_SAVEPOINT_MAP.computeIfAbsent(connection, unused -> new LinkedHashMap()).put(savepointName, result);
    }

    public void rollbackToSavepoint(Connection connection, String savepointName) throws SQLException {
        Optional<Savepoint> result = this.lookupSavepoint(connection, savepointName);
        if (result.isPresent()) {
            connection.rollback(result.get());
        }
    }

    public void releaseSavepoint(Connection connection, String savepointName) throws SQLException {
        Optional<Savepoint> result = this.lookupSavepoint(connection, savepointName);
        if (result.isPresent()) {
            connection.releaseSavepoint(result.get());
        }
    }

    private Optional<Savepoint> lookupSavepoint(Connection connection, String savepointName) {
        return Optional.ofNullable(CONNECTION_SAVEPOINT_MAP.get(connection)).map(optional -> (Savepoint)optional.get(savepointName));
    }

    public void transactionFinished(Connection connection) {
        CONNECTION_SAVEPOINT_MAP.remove(connection);
    }

    @Generated
    private ConnectionSavepointManager() {
    }
}

