/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.core;

import com.google.common.base.Preconditions;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.transaction.core.ResourceIDGenerator;

public final class ResourceDataSource {
    private final String originalName;
    private final String uniqueResourceName;
    private final DataSource dataSource;

    public ResourceDataSource(String originalName, DataSource dataSource) {
        String[] databaseAndDataSourceName = originalName.split("\\.");
        Preconditions.checkState((2 == databaseAndDataSourceName.length ? 1 : 0) != 0, (Object)String.format("Database and data source name must be provided,`%s`.", originalName));
        this.originalName = originalName;
        this.dataSource = dataSource;
        this.uniqueResourceName = ResourceIDGenerator.getInstance().nextId() + databaseAndDataSourceName[1];
    }

    @Generated
    public String getOriginalName() {
        return this.originalName;
    }

    @Generated
    public String getUniqueResourceName() {
        return this.uniqueResourceName;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }
}

