/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.rule;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.scope.GlobalRule;
import org.apache.shardingsphere.infra.rule.identifier.type.ResourceHeldRule;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.config.TransactionRuleConfiguration;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionRule
implements GlobalRule,
ResourceHeldRule<ShardingSphereTransactionManagerEngine> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionRule.class);
    private final TransactionRuleConfiguration configuration;
    private final TransactionType defaultType;
    private final String providerType;
    private final Properties props;
    private final Map<String, ShardingSphereDatabase> databases;
    private volatile ShardingSphereTransactionManagerEngine resource;

    public TransactionRule(TransactionRuleConfiguration ruleConfig, Map<String, ShardingSphereDatabase> databases, InstanceContext instanceContext) {
        log.debug("Create transaction rule");
        this.configuration = ruleConfig;
        this.defaultType = TransactionType.valueOf(ruleConfig.getDefaultType().toUpperCase());
        this.providerType = ruleConfig.getProviderType();
        this.props = ruleConfig.getProps();
        this.databases = databases;
        this.resource = this.createTransactionManagerEngine(databases);
    }

    private synchronized ShardingSphereTransactionManagerEngine createTransactionManagerEngine(Map<String, ShardingSphereDatabase> databases) {
        if (databases.isEmpty()) {
            return new ShardingSphereTransactionManagerEngine();
        }
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(databases.size());
        HashSet<DatabaseType> databaseTypes = new HashSet<DatabaseType>();
        for (Map.Entry<String, ShardingSphereDatabase> entry : databases.entrySet()) {
            ShardingSphereDatabase database = entry.getValue();
            database.getResourceMetaData().getDataSources().forEach((key, value) -> dataSourceMap.put(database.getName() + "." + key, (DataSource)value));
            if (null == entry.getValue().getResourceMetaData().getDatabaseType()) continue;
            databaseTypes.add(entry.getValue().getResourceMetaData().getDatabaseType());
        }
        Preconditions.checkState((databaseTypes.size() < 2 ? 1 : 0) != 0, (Object)"Multiple types of databases are not supported");
        if (dataSourceMap.isEmpty()) {
            return new ShardingSphereTransactionManagerEngine();
        }
        ShardingSphereTransactionManagerEngine result = new ShardingSphereTransactionManagerEngine();
        result.init((DatabaseType)databaseTypes.iterator().next(), dataSourceMap, this.providerType);
        return result;
    }

    public synchronized void addResource(ShardingSphereDatabase database) {
        if (null == database) {
            return;
        }
        log.debug("Transaction rule add resource: {}", (Object)database.getName());
        this.rebuildEngine();
    }

    public synchronized void closeStaleResource(String databaseName) {
        if (!this.databases.containsKey(databaseName.toLowerCase())) {
            return;
        }
        log.debug("Transaction rule close resource: {}", (Object)databaseName);
        this.rebuildEngine();
    }

    public synchronized void closeStaleResource() {
        log.debug("Transaction rule close all resources");
        this.closeEngine();
    }

    private void rebuildEngine() {
        ShardingSphereTransactionManagerEngine previousEngine = this.resource;
        if (null != previousEngine) {
            this.closeEngine(previousEngine);
        }
        this.resource = this.createTransactionManagerEngine(this.databases);
    }

    private void closeEngine() {
        ShardingSphereTransactionManagerEngine engine = this.resource;
        if (null != engine) {
            this.closeEngine(engine);
            this.resource = new ShardingSphereTransactionManagerEngine();
        }
    }

    private void closeEngine(ShardingSphereTransactionManagerEngine engine) {
        try {
            engine.close();
        }
        catch (Exception ex) {
            log.error("Close transaction engine failed", (Throwable)ex);
        }
    }

    public String getType() {
        return TransactionRule.class.getSimpleName();
    }

    @Generated
    public TransactionRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public TransactionType getDefaultType() {
        return this.defaultType;
    }

    @Generated
    public String getProviderType() {
        return this.providerType;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public Map<String, ShardingSphereDatabase> getDatabases() {
        return this.databases;
    }

    @Generated
    public ShardingSphereTransactionManagerEngine getResource() {
        return this.resource;
    }
}

