/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.transaction.core.ResourceDataSource;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingTransactionManager;
import org.apache.shardingsphere.transaction.xa.jta.datasource.XATransactionDataSource;
import org.apache.shardingsphere.transaction.xa.manager.XATransactionManagerLoader;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManager;

public final class XAShardingTransactionManager
implements ShardingTransactionManager {
    private final Map<String, XATransactionDataSource> cachedDataSources = new HashMap<String, XATransactionDataSource>();
    private XATransactionManager xaTransactionManager;

    public void init(DatabaseType databaseType, Collection<ResourceDataSource> resourceDataSources, String transactionMangerType) {
        this.xaTransactionManager = XATransactionManagerLoader.getInstance().getXATransactionManager(transactionMangerType);
        this.xaTransactionManager.init();
        resourceDataSources.forEach(each -> this.cachedDataSources.put(each.getOriginalName(), this.newXATransactionDataSource(databaseType, (ResourceDataSource)each)));
    }

    private XATransactionDataSource newXATransactionDataSource(DatabaseType databaseType, ResourceDataSource resourceDataSource) {
        String resourceName = resourceDataSource.getUniqueResourceName();
        DataSource dataSource = resourceDataSource.getDataSource();
        return new XATransactionDataSource(databaseType, resourceName, dataSource, this.xaTransactionManager);
    }

    public TransactionType getTransactionType() {
        return TransactionType.XA;
    }

    public boolean isInTransaction() {
        return 6 != this.xaTransactionManager.getTransactionManager().getStatus();
    }

    public Connection getConnection(String dataSourceName) throws SQLException {
        try {
            return this.cachedDataSources.get(dataSourceName).getConnection();
        }
        catch (RollbackException | SystemException ex) {
            throw new SQLException(ex);
        }
    }

    public void begin() {
        this.xaTransactionManager.getTransactionManager().begin();
    }

    public void commit() {
        this.xaTransactionManager.getTransactionManager().commit();
    }

    public void rollback() {
        this.xaTransactionManager.getTransactionManager().rollback();
    }

    public void close() throws Exception {
        for (XATransactionDataSource each : this.cachedDataSources.values()) {
            each.close();
        }
        this.cachedDataSources.clear();
        this.xaTransactionManager.close();
    }
}

