/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.connection.dialect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.shardingsphere.transaction.xa.jta.connection.XAConnectionWrapper;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXAConnection;
import org.h2.message.TraceObject;

public final class H2XAConnectionWrapper
implements XAConnectionWrapper {
    private static final int XA_DATA_SOURCE = 13;
    private static final Constructor<JdbcXAConnection> CONSTRUCTOR = H2XAConnectionWrapper.getH2JdbcXAConstructor();
    private static final Method NEXT_ID = H2XAConnectionWrapper.getNextIdMethod();
    private static final JdbcDataSourceFactory FACTORY = new JdbcDataSourceFactory();

    private static Constructor<JdbcXAConnection> getH2JdbcXAConstructor() {
        Constructor<JdbcXAConnection> result = JdbcXAConnection.class.getDeclaredConstructor(JdbcDataSourceFactory.class, Integer.TYPE, JdbcConnection.class);
        result.setAccessible(true);
        return result;
    }

    private static Method getNextIdMethod() {
        Method result = TraceObject.class.getDeclaredMethod("getNextId", Integer.TYPE);
        result.setAccessible(true);
        return result;
    }

    @Override
    public XAConnection wrap(XADataSource xaDataSource, Connection connection) {
        Connection physicalConnection = (Connection)connection.unwrap(JdbcConnection.class);
        return (XAConnection)CONSTRUCTOR.newInstance(FACTORY, NEXT_ID.invoke(null, 13), physicalConnection);
    }
}

