/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.datasource;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.transaction.xa.jta.connection.XAConnectionFactory;
import org.apache.shardingsphere.transaction.xa.jta.datasource.XADataSourceFactory;
import org.apache.shardingsphere.transaction.xa.spi.SingleXAResource;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManager;

public final class XATransactionDataSource
implements AutoCloseable {
    private static final Set<String> CONTAINER_DATASOURCE_NAMES = Sets.newHashSet((Object[])new String[]{"AtomikosDataSourceBean", "BasicManagedDataSource"});
    private final ThreadLocal<Set<Transaction>> enlistedTransactions = ThreadLocal.withInitial(HashSet::new);
    private final DatabaseType databaseType;
    private final String resourceName;
    private final DataSource dataSource;
    private XADataSource xaDataSource;
    private XATransactionManager xaTransactionManager;

    public XATransactionDataSource(DatabaseType databaseType, String resourceName, DataSource dataSource, XATransactionManager xaTransactionManager) {
        this.databaseType = databaseType;
        this.resourceName = resourceName;
        this.dataSource = dataSource;
        if (!CONTAINER_DATASOURCE_NAMES.contains(dataSource.getClass().getSimpleName())) {
            this.xaDataSource = XADataSourceFactory.build(databaseType, dataSource);
            this.xaTransactionManager = xaTransactionManager;
            xaTransactionManager.registerRecoveryResource(resourceName, this.xaDataSource);
        }
    }

    public Connection getConnection() throws SQLException, SystemException, RollbackException {
        if (CONTAINER_DATASOURCE_NAMES.contains(this.dataSource.getClass().getSimpleName())) {
            return this.dataSource.getConnection();
        }
        Connection result = this.dataSource.getConnection();
        XAConnection xaConnection = XAConnectionFactory.createXAConnection(this.databaseType, this.xaDataSource, result);
        final Transaction transaction = this.xaTransactionManager.getTransactionManager().getTransaction();
        if (!this.enlistedTransactions.get().contains(transaction)) {
            transaction.enlistResource((XAResource)new SingleXAResource(this.resourceName, xaConnection.getXAResource()));
            transaction.registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                    ((Set)XATransactionDataSource.this.enlistedTransactions.get()).remove(transaction);
                }

                public void afterCompletion(int status) {
                    ((Set)XATransactionDataSource.this.enlistedTransactions.get()).clear();
                }
            });
            this.enlistedTransactions.get().add(transaction);
        }
        return result;
    }

    @Override
    public void close() {
        if (!CONTAINER_DATASOURCE_NAMES.contains(this.dataSource.getClass().getSimpleName())) {
            this.xaTransactionManager.removeRecoveryResource(this.resourceName, this.xaDataSource);
        } else {
            this.close(this.dataSource);
        }
    }

    private void close(DataSource dataSource) {
        try {
            Method method = dataSource.getClass().getDeclaredMethod("close", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)dataSource, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

