/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.datasource.swapper;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.transaction.xa.jta.datasource.properties.XADataSourceDefinition;
import org.apache.shardingsphere.transaction.xa.jta.datasource.swapper.DataSourcePropertyProvider;
import org.apache.shardingsphere.transaction.xa.jta.datasource.swapper.DataSourcePropertyProviderLoader;

public final class DataSourceSwapper {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private final XADataSourceDefinition xaDataSourceDefinition;

    public XADataSource swap(DataSource dataSource) {
        XADataSource result = this.createXADataSource();
        this.setProperties(result, this.getDatabaseAccessConfiguration(dataSource));
        return result;
    }

    private XADataSource createXADataSource() {
        XADataSource result = null;
        LinkedList<ShardingSphereException> exceptions = new LinkedList<ShardingSphereException>();
        for (String each : this.xaDataSourceDefinition.getXADriverClassName()) {
            try {
                result = this.loadXADataSource(each);
            }
            catch (ShardingSphereException ex) {
                exceptions.add(ex);
            }
        }
        if (null == result && !exceptions.isEmpty()) {
            if (exceptions.size() > 1) {
                throw new ShardingSphereException("Failed to create [%s] XA DataSource", new Object[]{this.xaDataSourceDefinition});
            }
            throw (ShardingSphereException)((Object)exceptions.iterator().next());
        }
        return result;
    }

    private XADataSource loadXADataSource(String xaDataSourceClassName) {
        Class<?> xaDataSourceClass;
        try {
            xaDataSourceClass = Thread.currentThread().getContextClassLoader().loadClass(xaDataSourceClassName);
        }
        catch (ClassNotFoundException ignored) {
            try {
                xaDataSourceClass = Class.forName(xaDataSourceClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ShardingSphereException("Failed to load [%s]", new Object[]{xaDataSourceClassName});
            }
        }
        try {
            return (XADataSource)xaDataSourceClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ShardingSphereException("Failed to instance [%s]", new Object[]{xaDataSourceClassName});
        }
    }

    private Map<String, Object> getDatabaseAccessConfiguration(DataSource dataSource) {
        HashMap<String, Object> result = new HashMap<String, Object>(3, 1.0f);
        DataSourcePropertyProvider provider = DataSourcePropertyProviderLoader.getProvider(dataSource);
        try {
            result.put("url", this.findGetterMethod(dataSource, provider.getURLPropertyName()).invoke((Object)dataSource, new Object[0]));
            result.put("user", this.findGetterMethod(dataSource, provider.getUsernamePropertyName()).invoke((Object)dataSource, new Object[0]));
            result.put("password", this.findGetterMethod(dataSource, provider.getPasswordPropertyName()).invoke((Object)dataSource, new Object[0]));
            return result;
        }
        catch (ReflectiveOperationException ex) {
            throw new ShardingSphereException("Cannot swap data source type: `%s`, please provide an implementation from SPI `%s`", new Object[]{dataSource.getClass().getName(), DataSourcePropertyProvider.class.getName()});
        }
    }

    private void setProperties(XADataSource xaDataSource, Map<String, Object> databaseAccessConfig) {
        for (Map.Entry<String, Object> entry : databaseAccessConfig.entrySet()) {
            Optional<Method> method = this.findSetterMethod(xaDataSource.getClass().getMethods(), entry.getKey());
            if (!method.isPresent()) continue;
            method.get().invoke((Object)xaDataSource, entry.getValue());
        }
    }

    private Method findGetterMethod(DataSource dataSource, String propertyName) throws NoSuchMethodException {
        String getterMethodName = Joiner.on((String)"").join((Object)GETTER_PREFIX, (Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyName), new Object[0]);
        Method result = dataSource.getClass().getMethod(getterMethodName, new Class[0]);
        result.setAccessible(true);
        return result;
    }

    private Optional<Method> findSetterMethod(Method[] methods, String property) {
        String setterMethodName = Joiner.on((String)"").join((Object)SETTER_PREFIX, (Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, property), new Object[0]);
        return Arrays.stream(methods).filter(each -> each.getName().equals(setterMethodName) && 1 == each.getParameterTypes().length).findFirst();
    }

    @Generated
    public DataSourceSwapper(XADataSourceDefinition xaDataSourceDefinition) {
        this.xaDataSourceDefinition = xaDataSourceDefinition;
    }
}

